package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.PartyBuildingNews;

import java.util.List;

/**
 * 党建要闻Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
public interface PartyBuildingNewsMapper 
{
    /**
     * 查询党建要闻
     * 
     * @param id 党建要闻主键
     * @return 党建要闻
     */
    public PartyBuildingNews selectPartyBuildingNewsById(Long id);

    /**
     * 查询党建要闻列表
     * 
     * @param partyBuildingNews 党建要闻
     * @return 党建要闻集合
     */
    public List<PartyBuildingNews> selectPartyBuildingNewsList(PartyBuildingNews partyBuildingNews);

    /**
     * 新增党建要闻
     * 
     * @param partyBuildingNews 党建要闻
     * @return 结果
     */
    public int insertPartyBuildingNews(PartyBuildingNews partyBuildingNews);

    /**
     * 修改党建要闻
     * 
     * @param partyBuildingNews 党建要闻
     * @return 结果
     */
    public int updatePartyBuildingNews(PartyBuildingNews partyBuildingNews);

    /**
     * 删除党建要闻
     * 
     * @param id 党建要闻主键
     * @return 结果
     */
    public int deletePartyBuildingNewsById(Long id);

    /**
     * 批量删除党建要闻
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePartyBuildingNewsByIds(Long[] ids);
}
