package com.ruoyi.quartz.task;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.system.domain.publicservice.TOtherappAttachmentExample;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.domain.zb.ZbDutyWorkConfig;
import com.ruoyi.system.domain.zb.ZbDutyWorkConfigExample;
import com.ruoyi.system.domain.zb.ZbDutyWorkRule;
import com.ruoyi.system.domain.zb.ZbDutyWorkRuleExample;
import com.ruoyi.system.domain.zb.vo.DutyWorkVO;
import com.ruoyi.system.mapper.publicservice.TOtherappAttachmentMapper;
import com.ruoyi.system.mapper.zb.ZbDutyWorkConfigMapper;
import com.ruoyi.system.mapper.zb.ZbDutyWorkRuleMapper;
import com.ruoyi.system.service.zb.DutyWorkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * * Author: brenda
 * * 2025/1/21
 **/
@EnableScheduling
@EnableAsync
@Component
public class DutyWorkTask {

    @Autowired
    private ZbDutyWorkRuleMapper ruleMapper;
    @Autowired
    private ZbDutyWorkConfigMapper configMapper;
    @Autowired
    private DutyWorkService dutyWorkService;
    @Autowired
    private TOtherappAttachmentMapper otherappAttachmentMapper;

    @Async
    @Scheduled(cron = "0 0 8 * * *")
    @Transactional
    public void execute(){
        ZbDutyWorkConfigExample configExample = new ZbDutyWorkConfigExample();
        ZbDutyWorkConfigExample.Criteria configCriteria = configExample.createCriteria();
        Date today = DateUtils.getNowDate();
        configCriteria.andPublishDateEqualTo(today);
        configCriteria.andPublishFlagEqualTo(0);
        List<ZbDutyWorkConfig> configList = configMapper.selectByExampleWithBLOBs(configExample);
        if(!CollectionUtils.isEmpty(configList)){
            ZbDutyWorkConfig config = configList.get(0);
            DutyWorkVO dutyWorkVO = BeanCopyUtil.toBean(config, DutyWorkVO.class);
            TOtherappAttachmentExample otherappAttachmentExample = new TOtherappAttachmentExample();
            TOtherappAttachmentExample.Criteria criteria = otherappAttachmentExample.createCriteria();
            criteria.andBusinessIdEqualTo(config.getId());
            criteria.andAttachTypeEqualTo(AttachEnums.AttachType.ON_DUTY.name());
            dutyWorkVO.setFileList(otherappAttachmentMapper.selectByExample(otherappAttachmentExample));
            dutyWorkService.saveDutyWorkRecord(dutyWorkVO);
        }
        List<ZbDutyWorkRule> ruleList = ruleMapper.selectByExample(new ZbDutyWorkRuleExample());
        if(!CollectionUtils.isEmpty(ruleList)){
            ZbDutyWorkRule rule = ruleList.get(0);
            //已经是轮训的最后一天
            if(DateUtils.isToday(rule.getLastDay())){
                //若不是自动发布的，删除所有计划模板
                if(rule.getAutoFlag() == 0){
                    configMapper.deleteByExample(new ZbDutyWorkConfigExample());
                    ruleMapper.deleteByExample(new ZbDutyWorkRuleExample());
                }else{
                    List<ZbDutyWorkConfig> configs = configMapper.selectByExampleWithBLOBs(new ZbDutyWorkConfigExample());
                    configs.sort(Comparator.comparing(ZbDutyWorkConfig::getPublishDate));
                    for(ZbDutyWorkConfig config : configs){
                        config.setPublishFlag(0);
                        config.setCreateTime(new Date());
                        String newDateStr = DateUtils.parseDateToStr("yyyy年MM月dd日",DateUtils.addDate(config.getPublishDate(), rule.getDays()));
                        config.setTitle(newDateStr+"值班表");
                        config.setPublishDate(DateUtils.addDate(config.getPublishDate(), rule.getDays()));
                        configMapper.updateByPrimaryKey(config);
                    }
                    rule.setFirstDay(DateUtils.addDate(rule.getFirstDay(), rule.getDays()));
                    rule.setLastDay(DateUtils.addDate(rule.getLastDay(), rule.getDays()));
                    rule.setCreateTime(new Date());
                    ruleMapper.updateByPrimaryKeySelective(rule);
                }
            }
        }
    }
}
