package com.ruoyi.web.controller.md;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.md.dto.JbWorkBean;
import com.ruoyi.system.service.md.JbTodoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author vidar
 * date 2024/6/5
 * description 代办
 **/
@Api(tags = "代办")
@RestController
@RequestMapping("/api/md/work")
public class TodoController {
    @Resource
    private JbTodoService jbTodoService;

    /**
     * @param name:     待办名称，可选，用于查询筛选
     * @param uid:      用户uid，必填，用于筛选当前用户
     * @return
     * @Description: 获取待办列表
     */
    @ApiOperation("列表")
    @RequestMapping(value = "/todo/list", method = RequestMethod.GET)
    @ResponseBody
    public R<IPage<JbWorkBean>> todoList(@RequestParam(value = "pageNum", defaultValue = "1", required = false) Integer pageNum,
                      @RequestParam(value = "pageSize", defaultValue = "10", required = false) Integer pageSize,
                      @RequestParam(value = "name", required = false) String name,
                      @RequestParam(value = "uid") String uid) {
        if (StringUtils.isEmpty(uid)) {
            throw new ServiceException("缺少必要参数：uid不能为空");
        }
        IPage<JbWorkBean> result = jbTodoService.get(pageNum, pageSize, name, uid, 0);
        return R.ok(result);
    }
}
