package com.ruoyi.web.controller.task;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.task.request.TkCommonYinhuanAddRequest;
import com.ruoyi.system.domain.task.request.TkCommonYinhuanQueryRequest;
import com.ruoyi.system.domain.task.vo.TkCommonYinhuanVO;
import com.ruoyi.system.service.task.TkCommonYinhuanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author vidar
 * date 2024/6/14
 * description
 **/
@Api(tags = "工单 隐患矛盾")
@RestController
@RequestMapping("/api/task/yinhuan")
public class CommonYinhuanController extends BaseController {
    @Resource
    private TkCommonYinhuanService yinhuanService;

    @ApiOperation("新增")
    @PostMapping("add")
    public AjaxResult add(@RequestBody @Valid TkCommonYinhuanAddRequest request){
        yinhuanService.add(request,this.getUserId());
        return AjaxResult.success();
    }

    @ApiOperation("详情")
    @GetMapping("{id}")
    public AjaxResult detail(@PathVariable Long id){
        return AjaxResult.success(yinhuanService.getVOById(id));
    }

    @ApiOperation("分页")
    @PostMapping("page")
    public AjaxResult page(@RequestBody TkCommonYinhuanQueryRequest request){
        IPage<TkCommonYinhuanVO> page = yinhuanService.pageVO(request);
        return AjaxResult.success(page);
    }

    @ApiOperation("取消")
    @GetMapping("cancel/{id}")
    public AjaxResult cancel(@PathVariable Long id){
        yinhuanService.cancel(id);
        return AjaxResult.success();
    }
}
