package com.ruoyi.web.controller.system;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.enums.MenuRangeEnum;
import com.ruoyi.common.enums.MenuTypeEnum;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.system.SysRoleMenu;
import com.ruoyi.system.domain.system.enums.PermissionTypeEnum;
import com.ruoyi.system.mapper.system.SysMenuMapper;
import com.ruoyi.system.mapper.system.SysRoleMenuMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * * Author: brenda
 * * 2024/6/17
 **/
@Api(tags = "基础服务 - 权限设置")
@RestController
@RequestMapping("/system/permission")
public class SysNewPermissionController {

    @Autowired
    private SysRoleMenuMapper sysRoleMenuMapper;

    @Autowired
    private SysMenuMapper sysMenuMapper;

    @ApiOperation("权限类型枚举")
    @GetMapping("/type/enums")
    public AjaxResult typeEnums(){
        Map<String, String> map = new LinkedHashMap<>();
        map.put(PermissionTypeEnum.DEPT.getCode(), PermissionTypeEnum.DEPT.getValue());
        map.put(PermissionTypeEnum.ROLE.getCode(), PermissionTypeEnum.ROLE.getValue());
        map.put(PermissionTypeEnum.PERSONAL.getCode(), PermissionTypeEnum.PERSONAL.getValue());
        return AjaxResult.success(map);
    }

    @ApiOperation("批量新增权限")
    @PostMapping("/bathAdd")
    public AjaxResult bathAddPermission(@RequestBody List<SysRoleMenu> roleMenuList){
        if(CollectionUtils.isEmpty(roleMenuList)){
            throw new ServiceException("参数为空！");
        }
        if(StringUtils.isEmpty(roleMenuList.get(0).getType())
                || roleMenuList.get(0).getForeignId() == null
                || StringUtils.isEmpty(roleMenuList.get(0).getWorkRange())){
            throw new ServiceException("参数错误！");
        }
        List<SysRoleMenu> existRole = sysRoleMenuMapper.listByTypeAndForeignIdAndRange(roleMenuList.get(0).getType(), roleMenuList.get(0).getForeignId(), roleMenuList.get(0).getWorkRange());
        if(!CollectionUtils.isEmpty(existRole)){
            sysRoleMenuMapper.deleteAllRoles(existRole.stream().map(SysRoleMenu::getId).collect(Collectors.toList()));
        }
        if(roleMenuList.get(0).getMenuId() != null){
            sysRoleMenuMapper.batchRoleMenu(roleMenuList);
        }
        return AjaxResult.success();
    }

    @ApiOperation("某组织/角色/人员的权限列表")
    @GetMapping("/list")
    public AjaxResult getList(String type, String foreignId, String range){
        return AjaxResult.success(sysRoleMenuMapper.listByTypeAndForeignIdAndRange(type, foreignId, range));
    }

    @ApiOperation("全部应用/菜单/目录/按钮")
    @GetMapping("/listAll")
    public AjaxResult listAll(@RequestParam("range") String range){
        if(StringUtils.isEmpty(range)){
            throw new RuntimeException("参数错误！");
        }
        if(MenuRangeEnum.PC.getCode().equals(range)){
            SysMenu sysMenu = new SysMenu();
            sysMenu.setMenuType(MenuTypeEnum.APP.getCode());
            sysMenu.setWorkRange(MenuRangeEnum.PC.getCode());
            sysMenu.setStatus("0");
            List<SysMenu> sysMenuList = sysMenuMapper.selectMenuList(sysMenu);
            setMenuChildren(sysMenuList);
            return AjaxResult.success(sysMenuList);
        }else{
            //app菜单塞入一个rootMenuId来分类
            SysMenu sysMenu = new SysMenu();
            sysMenu.setStatus("0");
            sysMenu.setWorkRange(MenuRangeEnum.APP.getCode());
            List<SysMenu> sysMenuList = sysMenuMapper.selectMenuList(sysMenu);
            if(CollectionUtils.isNotEmpty(sysMenuList)){
                for(SysMenu sysMenu1 : sysMenuList){
                    setRootMenuId(sysMenu1);
                }
            }
            return AjaxResult.success(sysMenuList);
        }
    }

    private void setMenuChildren(List<SysMenu> list){
        if(!CollectionUtils.isEmpty(list)){
            for(SysMenu menu : list){
                SysMenu param = new SysMenu();
                param.setParentId(menu.getMenuId());
                param.setWorkRange(MenuRangeEnum.PC.getCode());
                param.setStatus("0");
                List<SysMenu> children = sysMenuMapper.selectMenuList(param);
                if(!CollectionUtils.isEmpty(children)){
                    setMenuChildren(children);
                    menu.setChildren(children);
                }
            }
        }
    }

    private void setRootMenuId(SysMenu menu){
        if(menu.getParentId() != null){
            SysMenu sysMenu = sysMenuMapper.selectMenuById(menu.getParentId());
            if(sysMenu != null){
                if(MenuTypeEnum.APP.getCode().equals(sysMenu.getMenuType())){
                    menu.setRootMenuId(sysMenu.getMenuId());
                    menu.setRootMenuName(sysMenu.getMenuName());
                }else{
                    setRootMenuId(sysMenu);
                }
            }
        }
    }
}

