package com.ruoyi.web.controller.operatingmanage;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.operatingmanage.TPublicServiceComInfo;
import com.ruoyi.system.service.operatingmanage.TPublicServiceComInfoService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 企业招聘 企业信息
 * @author wujm<wujm@eazytec.com>
 */
@Api(tags = "运营管理-生活公告栏")
@RestController
@RequestMapping("/api/publicservice/comInfo")
public class TPublicServiceComInfoController extends BaseController {
	
	@Autowired
	private TPublicServiceComInfoService tPublicServiceComInfoService;

	/**
	 * 列表
	 * @param tPublicServiceComInfo
	 * @return
	 */
	@GetMapping("/list")
	public TableDataInfo list(TPublicServiceComInfo tPublicServiceComInfo) {
		startPage();
		return getDataTable(tPublicServiceComInfoService.listTPublicServiceComInfo(tPublicServiceComInfo));
	}
		
	/**
	 * 新增
	 * @param tPublicServiceComInfo
	 * @return
	 */
	@Log(title = "新增企业招聘 企业信息", businessType = BusinessType.INSERT)
	@PostMapping("/add")
	public AjaxResult save(@RequestBody TPublicServiceComInfo tPublicServiceComInfo) {
		tPublicServiceComInfo.setCreateBy(getUsername());
		return toAjax(tPublicServiceComInfoService.saveComInfo(tPublicServiceComInfo));
	}
	
	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	@GetMapping("/{id}")
	public AjaxResult getById(@PathVariable("id") Long id) {
		TPublicServiceComInfo comInfo = tPublicServiceComInfoService.getTPublicServiceComInfoById(id);
		if(comInfo != null && StringUtils.isNotBlank(comInfo.getPostDesc())){
			String content = comInfo.getPostDesc().replaceAll("<image ", "<img ");
			comInfo.setPostDesc(content);
		}
		return AjaxResult.success();
	}
	
	/**
	 * 修改
	 * @param tPublicServiceComInfo
	 * @return
	 */
	@Log(title = "修改企业招聘 企业信息", businessType = BusinessType.UPDATE)
	@PutMapping("/update")
	public AjaxResult update(@RequestBody TPublicServiceComInfo tPublicServiceComInfo) {
		return toAjax(tPublicServiceComInfoService.updateTPublicServiceComInfo(tPublicServiceComInfo));
	}
	
	/**
	 * 删除
	 * @param ids
	 * @return
	 */
	@Log(title = "删除企业招聘 企业信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete")
	public AjaxResult batchRemove(@RequestBody Long[] ids) {
		return toAjax(tPublicServiceComInfoService.batchRemove(ids));
	}
	
}
