package com.ruoyi.common.zqt;

import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

/**
 * 导入Excel 工具类
 */
public class ZQTImportExcelUtil {

    //获取文件后缀
    public static String getPostFix(String path) {
        if (path == null || "".equals(path.trim())) {
            return "";
        }

        if (path.contains(".") && path.lastIndexOf(".") != path.length() - 1) {
            return path.substring(path.lastIndexOf(".") + 1, path.length());
        }

        return "";
    }

    //转换Cell类型的值
    public static String getValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == CellType.NUMERIC) {
            if (HSSFDateUtil.isCellDateFormatted(cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.format(HSSFDateUtil.getJavaDate(cell.getNumericCellValue()));
            } else {
                return new DecimalFormat("0.##").format(cell.getNumericCellValue());
            }
        } else if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        } else if (cell.getCellType() == CellType.FORMULA) {
            return String.valueOf(cell.getCellFormula());
        } else if (cell.getCellType() == CellType.BLANK) {
            return "";
        } else {
            return "";
        }
    }
}
