package com.ruoyi.system.service.other.impl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.system.domain.other.MapEntity;
import com.ruoyi.system.mapper.other.MapEntityMapper;
import com.ruoyi.system.service.other.MapEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class MapEntityServiceImpl implements MapEntityService {

    @Autowired
    private MapEntityMapper mapEntityMapper;

    @Override
    public List<MapEntity> getAllMapEntitiesByLevel(String level) {
        QueryWrapper<MapEntity> queryWrapper = new QueryWrapper<>();
        if(level!=null&& !level.isEmpty()){
            queryWrapper.eq("entity_level", level);
        }
        return mapEntityMapper.selectList(queryWrapper);
    }

    @Override
    public MapEntity getMapEntityById(String id) {
        return mapEntityMapper.selectById(id);
    }

    @Override
    public MapEntity updateMapEntity(String id, MapEntity mapEntity) {
        mapEntity.setId(id);
        mapEntityMapper.updateById(mapEntity);
        return mapEntity;
    }

    @Override
    public void deleteMapEntity(String id) {
        mapEntityMapper.deleteById(id);
    }

    @Override
    public MapEntity addMapEntityById(MapEntity mapEntity) {
        mapEntity.setId(UUID.randomUUID().toString());
        mapEntityMapper.insert(mapEntity);
        return mapEntity;
    }
}