package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.TProjectZj;
import com.eazytec.hkydatabasessynchronization.mapper.TProjectZjMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class TProjectZjEvent implements IBinlogEventHandler<TProjectZj> {

    private final TProjectZjMapper mapper;

    public TProjectZjEvent(TProjectZjMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<TProjectZj> binlogEvent) {
        TProjectZj data = binlogEvent.getData();
        TProjectZj tProjectZj = mapper.selectById(data.getId());
        if (Objects.isNull(tProjectZj)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(tProjectZj.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<TProjectZj> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<TProjectZj> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("t_project_zj");
    }
}
