package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.TProjectSchedule;
import com.eazytec.hkydatabasessynchronization.mapper.TProjectScheduleMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class TProjectScheduleEvent implements IBinlogEventHandler<TProjectSchedule> {

    private final TProjectScheduleMapper mapper;

    public TProjectScheduleEvent(TProjectScheduleMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<TProjectSchedule> binlogEvent) {
        TProjectSchedule data = binlogEvent.getData();
        TProjectSchedule tProjectSchedule = mapper.selectById(data.getId());
        if (Objects.isNull(tProjectSchedule)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(tProjectSchedule.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<TProjectSchedule> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<TProjectSchedule> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("t_project_schedule");
    }
}
