package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.TProjectNj;
import com.eazytec.hkydatabasessynchronization.mapper.TProjectNjMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class TProjectNjEvent implements IBinlogEventHandler<TProjectNj> {

    private final TProjectNjMapper mapper;

    public TProjectNjEvent(TProjectNjMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<TProjectNj> binlogEvent) {
        TProjectNj data = binlogEvent.getData();
        String planStart = data.getPlanStart();
        if (planStart.contains("/")) {
            planStart = planStart.replaceAll("/", "-");
        }
        data.setPlanStart(planStart.substring(0, 19));
        String planEnd = data.getPlanEnd();
        if (planEnd.contains("/")) {
            planEnd = planEnd.replaceAll("/", "-");
        }
        data.setPlanEnd(planEnd.substring(0, 19));
        TProjectNj tProjectNj = mapper.selectById(data.getId());
        if (Objects.isNull(tProjectNj)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(tProjectNj.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<TProjectNj> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<TProjectNj> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("t_project_nj");
    }
}
