package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.TProjectJg;
import com.eazytec.hkydatabasessynchronization.mapper.TProjectJgMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class TProjectJgEvent implements IBinlogEventHandler<TProjectJg> {

    private final TProjectJgMapper mapper;

    public TProjectJgEvent(TProjectJgMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<TProjectJg> binlogEvent) {
        TProjectJg data = binlogEvent.getData();
        TProjectJg tProjectJg = mapper.selectById(data.getId());
        if (Objects.isNull(tProjectJg)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(tProjectJg.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<TProjectJg> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<TProjectJg> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("t_project_jg");
    }
}
