package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.TProject;
import com.eazytec.hkydatabasessynchronization.mapper.TProjectMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class TProjectEvent implements IBinlogEventHandler<TProject> {

    private final TProjectMapper mapper;

    public TProjectEvent(TProjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<TProject> binlogEvent) {
        TProject data = binlogEvent.getData();
        TProject tProject = mapper.selectById(data.getId());
        if (Objects.isNull(tProject)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(tProject.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<TProject> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<TProject> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("t_project");
    }
}
