package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.PartyOrganization;
import com.eazytec.hkydatabasessynchronization.mapper.PartyOrganizationMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

@Singleton
public class PartyOrganizationEvent implements IBinlogEventHandler<PartyOrganization> {

    private final PartyOrganizationMapper mapper;

    public PartyOrganizationEvent(PartyOrganizationMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<PartyOrganization> binlogEvent) {
        mapper.insert(binlogEvent.getData());
    }

    @Override
    public void onUpdate(BinlogEvent<PartyOrganization> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<PartyOrganization> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
//        return s.equals("digital_hky") && s1.equals("party_organization");
        return false;
    }
}
