package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.PartyMember;
import com.eazytec.hkydatabasessynchronization.mapper.PartyMemberMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

@Singleton
public class PartyMemberEvent implements IBinlogEventHandler<PartyMember> {

    private final PartyMemberMapper mapper;

    public PartyMemberEvent(PartyMemberMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<PartyMember> binlogEvent) {
        mapper.insert(binlogEvent.getData());
    }

    @Override
    public void onUpdate(BinlogEvent<PartyMember> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<PartyMember> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
//        return s.equals("digital_hky") && s1.equals("party_member");
        return false;
    }
}
