package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.PartyDict;
import com.eazytec.hkydatabasessynchronization.mapper.PartyDictMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

@Singleton
public class PartyDictEvent implements IBinlogEventHandler<PartyDict> {

    private final PartyDictMapper mapper;

    public PartyDictEvent(PartyDictMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<PartyDict> binlogEvent) {
        mapper.insert(binlogEvent.getData());
    }

    @Override
    public void onUpdate(BinlogEvent<PartyDict> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<PartyDict> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
//        return s.equals("digital_hky") && s1.equals("party_dict");
        return false;
    }
}
