package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.PartyActivity;
import com.eazytec.hkydatabasessynchronization.mapper.PartyActivityMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

@Singleton
public class PartyActivityEvent implements IBinlogEventHandler<PartyActivity> {

    private final PartyActivityMapper mapper;

    public PartyActivityEvent(PartyActivityMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<PartyActivity> binlogEvent) {
        mapper.insert(binlogEvent.getData());
    }

    @Override
    public void onUpdate(BinlogEvent<PartyActivity> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<PartyActivity> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
//        return s.equals("digital_hky") && s1.equals("party_activity");
        return false;
    }
}
