package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.OTEmerspsSpsEnterpriseSpecialOperationPerson;
import com.eazytec.hkydatabasessynchronization.mapper.OTEmerspsSpsEnterpriseSpecialOperationPersonMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class OTEmerspsSpsEnterpriseSpecialOperationPersonEvent implements IBinlogEventHandler<OTEmerspsSpsEnterpriseSpecialOperationPerson> {

    private final OTEmerspsSpsEnterpriseSpecialOperationPersonMapper mapper;

    public OTEmerspsSpsEnterpriseSpecialOperationPersonEvent(OTEmerspsSpsEnterpriseSpecialOperationPersonMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<OTEmerspsSpsEnterpriseSpecialOperationPerson> binlogEvent) {
        OTEmerspsSpsEnterpriseSpecialOperationPerson data = binlogEvent.getData();
        OTEmerspsSpsEnterpriseSpecialOperationPerson otEmerspsSpsEnterpriseSpecialOperationPerson = mapper.selectById(data.getEnterpriseSpecialOperationPersonId());
        if (Objects.isNull(otEmerspsSpsEnterpriseSpecialOperationPerson)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(otEmerspsSpsEnterpriseSpecialOperationPerson.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<OTEmerspsSpsEnterpriseSpecialOperationPerson> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<OTEmerspsSpsEnterpriseSpecialOperationPerson> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("o_t_emersps_sps_enterprise_special_operation_person");
    }
}
