package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.EnterpriseBaseInfo;
import com.eazytec.hkydatabasessynchronization.entity.OTEmerspsSpsEnterpriseRealtimeAlarmRecord;
import com.eazytec.hkydatabasessynchronization.mapper.EnterpriseBaseInfoMapper;
import com.eazytec.hkydatabasessynchronization.mapper.OTEmerspsSpsEnterpriseRealtimeAlarmRecordMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class OTEmerspsSpsEnterpriseRealtimeAlarmRecordEvent implements IBinlogEventHandler<OTEmerspsSpsEnterpriseRealtimeAlarmRecord> {

    private final OTEmerspsSpsEnterpriseRealtimeAlarmRecordMapper mapper;

    public OTEmerspsSpsEnterpriseRealtimeAlarmRecordEvent(OTEmerspsSpsEnterpriseRealtimeAlarmRecordMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<OTEmerspsSpsEnterpriseRealtimeAlarmRecord> binlogEvent) {
        OTEmerspsSpsEnterpriseRealtimeAlarmRecord data = binlogEvent.getData();
        OTEmerspsSpsEnterpriseRealtimeAlarmRecord otEmerspsSpsEnterpriseRealtimeAlarmRecord = mapper.selectById(data.getEnterpriseRealtimeAlarmRecordId());
        if (Objects.isNull(otEmerspsSpsEnterpriseRealtimeAlarmRecord)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(otEmerspsSpsEnterpriseRealtimeAlarmRecord.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<OTEmerspsSpsEnterpriseRealtimeAlarmRecord> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<OTEmerspsSpsEnterpriseRealtimeAlarmRecord> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("o_t_emersps_sps_enterprise_realtime_alarm_record");
    }
}
