package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.OTEmerspsSpsEnterpriseLeakPoint;
import com.eazytec.hkydatabasessynchronization.mapper.OTEmerspsSpsEnterpriseLeakPointMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class OTEmerspsSpsEnterpriseLeakPointEvent implements IBinlogEventHandler<OTEmerspsSpsEnterpriseLeakPoint> {

    private final OTEmerspsSpsEnterpriseLeakPointMapper mapper;

    public OTEmerspsSpsEnterpriseLeakPointEvent(OTEmerspsSpsEnterpriseLeakPointMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<OTEmerspsSpsEnterpriseLeakPoint> binlogEvent) {
        OTEmerspsSpsEnterpriseLeakPoint data = binlogEvent.getData();
        OTEmerspsSpsEnterpriseLeakPoint otEmerspsSpsEnterpriseLeakPoint = mapper.selectById(data.getEnterpriseLeakPointId());
        if (Objects.isNull(otEmerspsSpsEnterpriseLeakPoint)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(otEmerspsSpsEnterpriseLeakPoint.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<OTEmerspsSpsEnterpriseLeakPoint> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<OTEmerspsSpsEnterpriseLeakPoint> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("o_t_emersps_sps_enterprise_leak_point");
    }
}
