package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.EnterpriseBaseInfo;
import com.eazytec.hkydatabasessynchronization.entity.OTEmerspsSpsEnterpriseHistoryHiddenTrouble;
import com.eazytec.hkydatabasessynchronization.mapper.EnterpriseBaseInfoMapper;
import com.eazytec.hkydatabasessynchronization.mapper.OTEmerspsSpsEnterpriseHistoryHiddenTroubleMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class OTEmerspsSpsEnterpriseHistoryHiddenTroubleEvent implements IBinlogEventHandler<OTEmerspsSpsEnterpriseHistoryHiddenTrouble> {

    private final OTEmerspsSpsEnterpriseHistoryHiddenTroubleMapper mapper;

    public OTEmerspsSpsEnterpriseHistoryHiddenTroubleEvent(OTEmerspsSpsEnterpriseHistoryHiddenTroubleMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<OTEmerspsSpsEnterpriseHistoryHiddenTrouble> binlogEvent) {
        OTEmerspsSpsEnterpriseHistoryHiddenTrouble data = binlogEvent.getData();
        OTEmerspsSpsEnterpriseHistoryHiddenTrouble otEmerspsSpsEnterpriseHistoryHiddenTrouble = mapper.selectById(data.getEnterpriseHistoryHiddenTroubleId());
        if (Objects.isNull(otEmerspsSpsEnterpriseHistoryHiddenTrouble)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(otEmerspsSpsEnterpriseHistoryHiddenTrouble.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<OTEmerspsSpsEnterpriseHistoryHiddenTrouble> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<OTEmerspsSpsEnterpriseHistoryHiddenTrouble> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("o_t_emersps_sps_enterprise_history_hidden_trouble");
    }
}
