package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.OTEmerspsSpsEnterpriseHazardousChemicals;
import com.eazytec.hkydatabasessynchronization.mapper.OTEmerspsSpsEnterpriseHazardousChemicalsMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class OTEmerspsSpsEnterpriseHazardousChemicalsEvent implements IBinlogEventHandler<OTEmerspsSpsEnterpriseHazardousChemicals> {

    private final OTEmerspsSpsEnterpriseHazardousChemicalsMapper mapper;

    public OTEmerspsSpsEnterpriseHazardousChemicalsEvent(OTEmerspsSpsEnterpriseHazardousChemicalsMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<OTEmerspsSpsEnterpriseHazardousChemicals> binlogEvent) {
        OTEmerspsSpsEnterpriseHazardousChemicals data = binlogEvent.getData();
        OTEmerspsSpsEnterpriseHazardousChemicals otEmerspsSpsEnterpriseHazardousChemicals = mapper.selectById(data.getEnterpriseHazardousChemicalsId());
        if (Objects.isNull(otEmerspsSpsEnterpriseHazardousChemicals)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(otEmerspsSpsEnterpriseHazardousChemicals.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<OTEmerspsSpsEnterpriseHazardousChemicals> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<OTEmerspsSpsEnterpriseHazardousChemicals> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("o_t_emersps_sps_enterprise_hazardous_chemicals");
    }
}
