package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.OTBaseIstProject;
import com.eazytec.hkydatabasessynchronization.mapper.OTBaseIstProjectMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

@Singleton
public class OTBaseIstProjectEvent implements IBinlogEventHandler<OTBaseIstProject> {

    private final OTBaseIstProjectMapper mapper;

    public OTBaseIstProjectEvent(OTBaseIstProjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<OTBaseIstProject> binlogEvent) {
        mapper.insert(binlogEvent.getData());
    }

    @Override
    public void onUpdate(BinlogEvent<OTBaseIstProject> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<OTBaseIstProject> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
//        return s.equals("digital_hky") && s1.equals("o_t_base_ist_project");
        return false;
    }
}
