package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.EnterpriseTestReport;
import com.eazytec.hkydatabasessynchronization.mapper.EnterpriseTestReportMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class EnterpriseTestReportEvent implements IBinlogEventHandler<EnterpriseTestReport> {

    private final EnterpriseTestReportMapper mapper;

    public EnterpriseTestReportEvent(EnterpriseTestReportMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<EnterpriseTestReport> binlogEvent) {
        EnterpriseTestReport data = binlogEvent.getData();
        EnterpriseTestReport enterpriseTestReport = mapper.selectById(data.getEnterpriseRiskPartitionId());
        if (Objects.isNull(enterpriseTestReport)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(enterpriseTestReport.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<EnterpriseTestReport> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<EnterpriseTestReport> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("enterprise_test_report");
    }
}
