package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.EnterpriseRescueTeam;
import com.eazytec.hkydatabasessynchronization.mapper.EnterpriseRescueTeamMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class EnterpriseRescueTeamEvent implements IBinlogEventHandler<EnterpriseRescueTeam> {

    private final EnterpriseRescueTeamMapper mapper;

    public EnterpriseRescueTeamEvent(EnterpriseRescueTeamMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<EnterpriseRescueTeam> binlogEvent) {
        EnterpriseRescueTeam data = binlogEvent.getData();
        EnterpriseRescueTeam enterpriseRescueTeam = mapper.selectById(data.getEnterpriseEmergencyRescueTeamId());
        if (Objects.isNull(enterpriseRescueTeam)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(enterpriseRescueTeam.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<EnterpriseRescueTeam> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<EnterpriseRescueTeam> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("enterprise_rescue_team");
    }
}
