package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.EnterpriseRescueMaterial;
import com.eazytec.hkydatabasessynchronization.mapper.EnterpriseRescueMaterialMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class EnterpriseRescueMaterialEvent implements IBinlogEventHandler<EnterpriseRescueMaterial> {

    private final EnterpriseRescueMaterialMapper mapper;

    public EnterpriseRescueMaterialEvent(EnterpriseRescueMaterialMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<EnterpriseRescueMaterial> binlogEvent) {
        EnterpriseRescueMaterial data = binlogEvent.getData();
        EnterpriseRescueMaterial enterpriseRescueMaterial = mapper.selectById(data.getEnterpriseEmergencyRescueMaterialId());
        if (Objects.isNull(enterpriseRescueMaterial)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(enterpriseRescueMaterial.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<EnterpriseRescueMaterial> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<EnterpriseRescueMaterial> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("enterprise_rescue_material");
    }
}
