package com.eazytec.hkydatabasessynchronization.event;

import com.eazytec.hkydatabasessynchronization.entity.EnterpriseBaseInfo;
import com.eazytec.hkydatabasessynchronization.mapper.EnterpriseBaseInfoMapper;
import com.gitee.Jmysy.binlog4j.core.BinlogEvent;
import com.gitee.Jmysy.binlog4j.core.IBinlogEventHandler;
import jakarta.inject.Singleton;

import java.util.Objects;

@Singleton
public class EnterpriseBaseInfoEvent implements IBinlogEventHandler<EnterpriseBaseInfo> {

    private final EnterpriseBaseInfoMapper mapper;

    public EnterpriseBaseInfoEvent(EnterpriseBaseInfoMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void onInsert(BinlogEvent<EnterpriseBaseInfo> binlogEvent) {
        EnterpriseBaseInfo data = binlogEvent.getData();
        EnterpriseBaseInfo enterpriseBaseInfo = mapper.selectById(data.getEnterpriseId());
        if (Objects.isNull(enterpriseBaseInfo)) {
            mapper.insert(data);
        } else {
            if (Objects.isNull(enterpriseBaseInfo.getEditStatus())) {
                mapper.updateById(data);
            }
        }
    }

    @Override
    public void onUpdate(BinlogEvent<EnterpriseBaseInfo> binlogEvent) {

    }

    @Override
    public void onDelete(BinlogEvent<EnterpriseBaseInfo> binlogEvent) {

    }

    @Override
    public boolean isHandle(String s, String s1) {
        return s.equals("digital_hky") && s1.equals("enterprise_base_info");
    }
}
