package com.eazytec.hkydatabasessynchronization.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.IdType;

/**
 * 项目信息表
 *
 * @author lx
 * @since 2024-10-12 17:33
 */
@TableName("t_project")
public class TProject implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 删除日期
     */
    private Date deleteDate;

    /**
     * 删除人
     */
    private String deleter;

    /**
     * 更新日期
     */
    private Date updateDate;

    /**
     * 更新人
     */
    private String updater;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序
     */
    private Long sort;

    /**
     * 删除状态（A:正常D:已删除）
     */
    private String sts;

    /**
     * 区域id
     */
    private String areaId;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 项目描述
     */
    private String description;

    /**
     * 是否重大项目0否1是
     */
    private Integer great;

    /**
     * 项目总投资
     */
    private String invest;

    /**
     * gps坐标
     */
    private String mapAddr;

    /**
     * 项目性质1新建2技改
     */
    private Integer mode;

    /**
     * 项目地址
     */
    private String projectAddr;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 备案号
     */
    private String recordCode;

    /**
     * 备案日期
     */
    private Date recordDate;

    /**
     * 项目状态10拟建2在建3竣工
     */
    private Integer stage;

    /**
     * odm入库时间
     */
    @TableField("odm_rksj")
    private Date odmRksj;

    private Integer editStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public Date getDeleteDate() {
        return deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public String getDeleter() {
        return deleter;
    }

    public void setDeleter(String deleter) {
        this.deleter = deleter;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getUpdater() {
        return updater;
    }

    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getSort() {
        return sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public String getSts() {
        return sts;
    }

    public void setSts(String sts) {
        this.sts = sts;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getGreat() {
        return great;
    }

    public void setGreat(Integer great) {
        this.great = great;
    }

    public String getInvest() {
        return invest;
    }

    public void setInvest(String invest) {
        this.invest = invest;
    }

    public String getMapAddr() {
        return mapAddr;
    }

    public void setMapAddr(String mapAddr) {
        this.mapAddr = mapAddr;
    }

    public Integer getMode() {
        return mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public String getProjectAddr() {
        return projectAddr;
    }

    public void setProjectAddr(String projectAddr) {
        this.projectAddr = projectAddr;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getRecordCode() {
        return recordCode;
    }

    public void setRecordCode(String recordCode) {
        this.recordCode = recordCode;
    }

    public Date getRecordDate() {
        return recordDate;
    }

    public void setRecordDate(Date recordDate) {
        this.recordDate = recordDate;
    }

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Date getOdmRksj() {
        return odmRksj;
    }

    public void setOdmRksj(Date odmRksj) {
        this.odmRksj = odmRksj;
    }

    public Integer getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }
}
