package com.eazytec.hkydatabasessynchronization.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.IdType;

/**
 * 企业安全监测实时告警记录
 *
 * @author lx
 * @since 2024-10-12 17:33
 */
@TableName("o_t_emersps_sps_enterprise_realtime_alarm_record")
public class OTEmerspsSpsEnterpriseRealtimeAlarmRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "enterprise_realtime_alarm_record_id", type = IdType.AUTO)
    private String enterpriseRealtimeAlarmRecordId;

    /**
     * 企业id
     */
    private String enterpriseId;

    /**
     * 监测设备id
     */
    private String deviceId;

    /**
     * 监测设备名称
     */
    private String deviceName;

    /**
     * 监测类型
     */
    private String monitoringType;

    /**
     * 告警内容
     */
    private String alarmContent;

    /**
     * 监测值
     */
    private String monitoringValue;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 告警时间
     */
    private Date alarmTime;

    /**
     * odm入库时间
     */
    @TableField("odm_rksj")
    private Date odmRksj;

    private Integer editStatus;

    public String getEnterpriseRealtimeAlarmRecordId() {
        return enterpriseRealtimeAlarmRecordId;
    }

    public void setEnterpriseRealtimeAlarmRecordId(String enterpriseRealtimeAlarmRecordId) {
        this.enterpriseRealtimeAlarmRecordId = enterpriseRealtimeAlarmRecordId;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getMonitoringType() {
        return monitoringType;
    }

    public void setMonitoringType(String monitoringType) {
        this.monitoringType = monitoringType;
    }

    public String getAlarmContent() {
        return alarmContent;
    }

    public void setAlarmContent(String alarmContent) {
        this.alarmContent = alarmContent;
    }

    public String getMonitoringValue() {
        return monitoringValue;
    }

    public void setMonitoringValue(String monitoringValue) {
        this.monitoringValue = monitoringValue;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Date getAlarmTime() {
        return alarmTime;
    }

    public void setAlarmTime(Date alarmTime) {
        this.alarmTime = alarmTime;
    }

    public Date getOdmRksj() {
        return odmRksj;
    }

    public void setOdmRksj(Date odmRksj) {
        this.odmRksj = odmRksj;
    }

    public Integer getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }
}
