package com.eazytec.hkydatabasessynchronization.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.IdType;

/**
 * 企业隐患问题 - 企业历史隐患
 *
 * @author lx
 * @since 2024-10-12 17:33
 */
@TableName("o_t_emersps_sps_enterprise_history_hidden_trouble")
public class OTEmerspsSpsEnterpriseHistoryHiddenTrouble implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "enterprise_history_hidden_trouble_id", type = IdType.AUTO)
    private String enterpriseHistoryHiddenTroubleId;

    /**
     * 企业ID
     */
    private String enterpriseId;

    /**
     * 企业名称
     */
    private String enterpriseName;

    /**
     * 检查单位
     */
    private String checkUnit;

    /**
     * 检查人员
     */
    private String checkPerson;

    /**
     * 检查时间
     */
    private Date checkTime;

    /**
     * 隐患内容
     */
    private String hiddenTroubleContent;

    /**
     * 隐患因素
     */
    private String hiddenTroubleFactors;

    /**
     * 隐患级别
     */
    private String hiddenTroubleLevel;

    /**
     * 隐患状态
     */
    private String hiddenTroubleStatus;

    /**
     * 隐患描述
     */
    private String hiddenTroubleDescribe;

    /**
     * 数据来源ID
     */
    private String dataSourceId;

    /**
     * 创建时间
     */
    private Date gmtCreated;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 数据锁版本号
     */
    private String dataVersion;

    /**
     * 检索题名
     */
    private String searchTitle;

    /**
     * 隐患来源（1：安全生产巡查 2：挂牌督办 3：行业部门检查 4：投诉信访举报 5：电话举报 6：其它）
     */
    private String hiddenTroubleSource;

    /**
     * 检查单位所属区域
     */
    private String coArea;

    /**
     * odm入库时间
     */
    @TableField("odm_rksj")
    private Date odmRksj;

    private Integer editStatus;

    public String getEnterpriseHistoryHiddenTroubleId() {
        return enterpriseHistoryHiddenTroubleId;
    }

    public void setEnterpriseHistoryHiddenTroubleId(String enterpriseHistoryHiddenTroubleId) {
        this.enterpriseHistoryHiddenTroubleId = enterpriseHistoryHiddenTroubleId;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }

    public String getCheckPerson() {
        return checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getHiddenTroubleContent() {
        return hiddenTroubleContent;
    }

    public void setHiddenTroubleContent(String hiddenTroubleContent) {
        this.hiddenTroubleContent = hiddenTroubleContent;
    }

    public String getHiddenTroubleFactors() {
        return hiddenTroubleFactors;
    }

    public void setHiddenTroubleFactors(String hiddenTroubleFactors) {
        this.hiddenTroubleFactors = hiddenTroubleFactors;
    }

    public String getHiddenTroubleLevel() {
        return hiddenTroubleLevel;
    }

    public void setHiddenTroubleLevel(String hiddenTroubleLevel) {
        this.hiddenTroubleLevel = hiddenTroubleLevel;
    }

    public String getHiddenTroubleStatus() {
        return hiddenTroubleStatus;
    }

    public void setHiddenTroubleStatus(String hiddenTroubleStatus) {
        this.hiddenTroubleStatus = hiddenTroubleStatus;
    }

    public String getHiddenTroubleDescribe() {
        return hiddenTroubleDescribe;
    }

    public void setHiddenTroubleDescribe(String hiddenTroubleDescribe) {
        this.hiddenTroubleDescribe = hiddenTroubleDescribe;
    }

    public String getDataSourceId() {
        return dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getDataVersion() {
        return dataVersion;
    }

    public void setDataVersion(String dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String getSearchTitle() {
        return searchTitle;
    }

    public void setSearchTitle(String searchTitle) {
        this.searchTitle = searchTitle;
    }

    public String getHiddenTroubleSource() {
        return hiddenTroubleSource;
    }

    public void setHiddenTroubleSource(String hiddenTroubleSource) {
        this.hiddenTroubleSource = hiddenTroubleSource;
    }

    public String getCoArea() {
        return coArea;
    }

    public void setCoArea(String coArea) {
        this.coArea = coArea;
    }

    public Date getOdmRksj() {
        return odmRksj;
    }

    public void setOdmRksj(Date odmRksj) {
        this.odmRksj = odmRksj;
    }

    public Integer getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }
}
