package com.eazytec.hkydatabasessynchronization.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.IdType;

/**
 * 企业风险分区
 *
 * @author lx
 * @since 2024-10-12 17:33
 */
@TableName("enterprise_test_report")
public class EnterpriseTestReport implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "enterprise_risk_partition_id", type = IdType.AUTO)
    private String enterpriseRiskPartitionId;

    /**
     * 企业ID
     */
    private String enterpriseId;

    /**
     * 企业名称
     */
    private String enterpriseName;

    /**
     * 风险图名称
     */
    private String riskPhotoName;

    /**
     * 风险图类型
     */
    private String riskPhotoType;

    /**
     * 评估时间
     */
    private Date assessmentTime;

    /**
     * 复评时间
     */
    private Date reevaluationTime;

    /**
     * 评估人
     */
    private String assessor;

    /**
     * 创建时间
     */
    private Date gmtCreated;

    /**
     * 检索题名
     */
    private String searchTitle;

    /**
     * 风险图
     */
    private String riskPhoto;

    /**
     * 数据来源ID
     */
    private String dataSourceId;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 数据锁版本号
     */
    private String dataVersion;

    /**
     * odm入库时间
     */
    @TableField("odm_rksj")
    private Date odmRksj;

    private Integer editStatus;

    public String getEnterpriseRiskPartitionId() {
        return enterpriseRiskPartitionId;
    }

    public void setEnterpriseRiskPartitionId(String enterpriseRiskPartitionId) {
        this.enterpriseRiskPartitionId = enterpriseRiskPartitionId;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getRiskPhotoName() {
        return riskPhotoName;
    }

    public void setRiskPhotoName(String riskPhotoName) {
        this.riskPhotoName = riskPhotoName;
    }

    public String getRiskPhotoType() {
        return riskPhotoType;
    }

    public void setRiskPhotoType(String riskPhotoType) {
        this.riskPhotoType = riskPhotoType;
    }

    public Date getAssessmentTime() {
        return assessmentTime;
    }

    public void setAssessmentTime(Date assessmentTime) {
        this.assessmentTime = assessmentTime;
    }

    public Date getReevaluationTime() {
        return reevaluationTime;
    }

    public void setReevaluationTime(Date reevaluationTime) {
        this.reevaluationTime = reevaluationTime;
    }

    public String getAssessor() {
        return assessor;
    }

    public void setAssessor(String assessor) {
        this.assessor = assessor;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public String getSearchTitle() {
        return searchTitle;
    }

    public void setSearchTitle(String searchTitle) {
        this.searchTitle = searchTitle;
    }

    public String getRiskPhoto() {
        return riskPhoto;
    }

    public void setRiskPhoto(String riskPhoto) {
        this.riskPhoto = riskPhoto;
    }

    public String getDataSourceId() {
        return dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getDataVersion() {
        return dataVersion;
    }

    public void setDataVersion(String dataVersion) {
        this.dataVersion = dataVersion;
    }

    public Date getOdmRksj() {
        return odmRksj;
    }

    public void setOdmRksj(Date odmRksj) {
        this.odmRksj = odmRksj;
    }

    public Integer getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }
}
