package com.eazytec.hkydatabasessynchronization.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.IdType;

/**
 * 安环企业档案 企业基本信息
 *
 * @author lx
 * @since 2024-10-12 18:16
 */
@TableName("enterprise_base_info")
public class EnterpriseBaseInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 企业id
     */
    @TableId(value = "enterprise_id", type = IdType.AUTO)
    private String enterpriseId;

    /**
     * 企业名称
     */
    private String enterpriseName;

    /**
     * 规模情况
     */
    private String scaleCondition;

    /**
     * 企业类型
     */
    private String enterpriseType;

    /**
     * 是否在化工园区内
     */
    private String inChemicalIndustry;

    /**
     * 职工人数
     */
    private String employees;

    /**
     * 实际经营地址
     */
    private String address;

    /**
     * 法定代表人
     */
    private String legalRepresentative;

    /**
     * 法定代表人手机
     */
    private String legalRepresentativeMobile;

    /**
     * 注册地址
     */
    private String registeredAddress;

    /**
     * 检索题名
     */
    private String searchTitle;

    /**
     * 企业主要负责人
     */
    private String majorResponsiblePerson;

    /**
     * 企业主要负责人联系方式
     */
    private String majorResponsiblePersonContact;

    /**
     * 企业安全负责人
     */
    private String satetyResponsiblePerson;

    /**
     * 企业安全负责人联系方式
     */
    private String satetyResponsiblePersonContact;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCreditCode;

    /**
     * 所在乡镇
     */
    private String town;

    /**
     * 企业简称
     */
    private String enterpriseAbbreviation;

    /**
     * 企业统一信用代码
     */
    private String enterpriseUnifiedCreditCode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 地图区域
     */
    private String mapArea;

    /**
     * 行政区域编码
     */
    private String administrativeCode;

    /**
     * 企业规模
     */
    private String enterpriseScale;

    /**
     * 经济类型
     */
    private String economicType;

    /**
     * 行业门类
     */
    private String industryCategory;

    /**
     * 行业大类
     */
    private String industryCategories;

    /**
     * 监管分类
     */
    private String regulatoryClassification;

    /**
     * 监管分类_危化处
     */
    private String regulatoryClassificationWhc;

    /**
     * 占地面积
     */
    private String areaCovered;

    /**
     * 企业平面图
     */
    private String enterprisePlan;

    /**
     * 行政隶属关系
     */
    private String administrativeSubordination;

    /**
     * 所属化工园区名称
     */
    private String chemicalIndustryName;

    /**
     * 危险化学品作业人数
     */
    private String hazardousChemicalsWorkers;

    /**
     * 特殊作业人数
     */
    private String specialOperationWorkers;

    /**
     * 剧毒化学品作业人数
     */
    private String toxicChemicalsWorkers;

    /**
     * 企业状态
     */
    private String enterpriseStatus;

    /**
     * 建筑面积
     */
    private String buildArea;

    /**
     * 上年度营业收入
     */
    private String lastYearBusinessIncome;

    /**
     * 资产总额
     */
    private String totalAssets;

    /**
     * 数据来源ID
     */
    private String dataSourceId;

    /**
     * 监管小类
     */
    private String regulatoryLittleClassification;

    /**
     * 删除标识
     */
    private String deleted;

    /**
     * 安全生产许可证编号
     */
    private String safetyProductionNumber;

    /**
     * 安全生产许可证开始日期
     */
    private String safetyProductionStartTime;

    /**
     * 安全生产许可证结束日期
     */
    private String safetyProductionEndTime;

    /**
     * 是否设有安全机构
     */
    private String safeOrganization;

    /**
     * 是否涉及重点监管危化品
     */
    private String supervisionHazardousChemicals;

    /**
     * 是否涉及剧毒品生产或者使用
     */
    private String highlyToxicProduce;

    /**
     * 是否涉及高危工艺
     */
    private String highRiskTechnology;

    /**
     * 是否构成重大危险源
     */
    private String majorHazard;

    /**
     * 重大危险源等级
     */
    private String majorHazardLevel;

    /**
     * 安全值班电话
     */
    private String safetyDutyTelephone;

    /**
     * 是否通过安全生产标准化
     */
    private String safeProductionStandard;

    /**
     * 安全生产诚信承诺书
     */
    private String safeProductionPromise;

    /**
     * 法定代表人职务
     */
    private String legalRepresentativePost;

    /**
     * 所在区县
     */
    private String area;

    /**
     * 成立日期
     */
    private Date establishDate;

    /**
     * 营业执照类型
     */
    private String businessLicenseType;

    /**
     * 营业执照
     */
    private String businessLicense;

    /**
     * 注册资金
     */
    private String registeredCapital;

    /**
     * 经营范围
     */
    private String businessRange;

    /**
     * 营业执照有效期结束时间
     */
    private Date licenseValidateEndTime;

    /**
     * 营业执照有效期开始时间
     */
    private Date licenseValidateStartTime;

    /**
     * 是否配备管理机构
     */
    private String managementOrganization;

    /**
     * 主要负责人合格证书
     */
    private String responsiblePersonPrincipal;

    /**
     * 安全管理人员合格证书
     */
    private String safePersonPrincipal;

    /**
     * 安全管理人员-专职人数
     */
    private String safePersonFullTimeCount;

    /**
     * 安全管理人员-兼职人数
     */
    private String safePersonPartTimeCount;

    /**
     * 是否执行安全总监
     */
    private String safetyDirector;

    /**
     * 安全总监姓名
     */
    private String safetyDirectorName;

    /**
     * 预案备案
     */
    private String planFiling;

    /**
     * 安全管理机构营业执照
     */
    private String safetyBusinessLicense;

    /**
     * 安全生产诚信承诺书
     */
    private String safetyProductionPromise;

    /**
     * 安全申报人
     */
    private String safetyDeclarant;

    /**
     * 安全申报人手机号
     */
    private String safetyDeclarantPhone;

    /**
     * 安全机构审核时间
     */
    private Date safetyOrgApprovelTime;

    /**
     * 安全机构审核结果
     */
    private String safetyOrgApprovelResult;

    /**
     * 是否列入化工行业
     */
    private String inclusionChemicalIndustry;

    /**
     * 是否涉及危险化学品
     */
    private String hazardousChemicals;

    /**
     * 是否存在危化品仓库储罐
     */
    private String dangerousChemicalsWarehouse;

    /**
     * 是否危化品输送管道
     */
    private String dangerousChemicalsPipeline;

    /**
     * 是否涉及重点监管危险化工工艺
     */
    private String supervisionHazardousTechnology;

    /**
     * 是否存在危化八大危险作业
     */
    private String eightDangerousOperations;

    /**
     * trade_enterprises_dangerous
     */
    private String tradeEnterprisesDangerous;

    /**
     * 是否存在职业病危害因素
     */
    private String occupationalHazards;

    /**
     * 是否存在有限空间
     */
    private String limitedSpace;

    /**
     * 是否涉氨制冷
     */
    private String ammoniaRefrigeration;

    /**
     * 是否涉及可燃粉尘
     */
    private String combustibleDust;

    /**
     * 是否涉及金属冶炼
     */
    private String metalSmelting;

    /**
     * 是否存在特种作业
     */
    private String specialOperation;

    /**
     * 是否厂中厂
     */
    private String factoryInFactory;

    /**
     * 是否深井铸造
     */
    private String deepWellCasting;

    /**
     * 是否涉尘涉爆
     */
    private String dustAndExplosion;

    /**
     * 是否钢铁工业
     */
    private String steelIndustry;

    /**
     * 从业人员总数
     */
    private String employeesCount;

    /**
     * 生产职工总数
     */
    private String productionStaffCount;

    /**
     * 企业班组长总数
     */
    private String enterpriseTeamLeaderCount;

    /**
     * 特种作业人员总数
     */
    private String specialOperationPersonnelCount;

    private String bachelorDegreeCount;

    /**
     * 大专或高职学历人数
     */
    private String juniorCollegeCount;

    /**
     * 高中或中职学历人数
     */
    private String highSchoolCount;

    /**
     * 初中学历人数
     */
    private String juniorMiddleSchoolCount;

    /**
     * 初中以下学历人数
     */
    private String underJuniorMiddleSchoolCount;

    /**
     * 接受职业资格教育并取证人数
     */
    private String receivedVocationalCount;

    /**
     * 接受技能培训人数
     */
    private String receivingSkillCount;

    /**
     * 从业人员中农民工数量
     */
    private String migrantWorkersCount;

    /**
     * 从业人员劳动派遣工数量
     */
    private String laborDispatchWorkers;

    /**
     * 近3年平均每年新招录工作数量
     */
    private String threeYearsAverageWorkers;

    /**
     * 创建时间
     */
    private Date gmtCreated;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 数据锁版本号
     */
    private String dataVersion;

    /**
     * 聘用专家
     */
    private String employExpert;

    /**
     * 聘用技术服务机构
     */
    private String employTechServiceOrg;

    /**
     * 危险化学品等级
     */
    private String dangerChemicalLevel;

    /**
     * 安全生产标准化等级
     */
    private String safetyProductStandardLevel;

    /**
     * 重点监管领域
     */
    private String keyRegulatoryArea;

    /**
     * 企业等级
     */
    private String enterpriseLevel;

    /**
     * 移除监管
     */
    private String moveSupervise;

    /**
     * 移除监管原因
     */
    private String moveSuperviseReason;

    /**
     * 注册安全工程师人数
     */
    private String registerSafetyEngineerNum;

    /**
     * 安全生产标准化建设情况
     */
    private String safetyProductStandardExplain;

    /**
     * 安全管理部门
     */
    private String safetyManageDeptName;

    /**
     * 申报人
     */
    private String declarant;

    /**
     * 申报人手机号
     */
    private String declarantPhone;

    /**
     * 审核时间
     */
    private Date approvelTime;

    /**
     * 审核结果
     */
    private String approvelResult;

    /**
     * 是否医药企业
     */
    private String medicineIndustry;

    /**
     * 是否烟花爆竹企业
     */
    private String fireworksIndustry;

    /**
     * 是否化工企业
     */
    private String chemicalIndustry;

    /**
     * 监管部门
     */
    private String superviseDept;

    /**
     * 是否有视频监控
     */
    private String videoMonitor;

    /**
     * 是否安装传感器
     */
    private String sensorMonitor;

    /**
     * 是否市重点监管企业
     */
    private String citySupervision;

    /**
     * 法定代表人性别
     */
    private String legalRepresentativeGender;

    /**
     * 法定代表人年龄
     */
    private String legalRepresentativeAge;

    /**
     * 企业信用等级
     */
    private String enterpriseCreditGrade;

    /**
     * odm入库时间
     */
    @TableField("odm_rksj")
    private Date odmRksj;

    private Integer editStatus;

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getScaleCondition() {
        return scaleCondition;
    }

    public void setScaleCondition(String scaleCondition) {
        this.scaleCondition = scaleCondition;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getInChemicalIndustry() {
        return inChemicalIndustry;
    }

    public void setInChemicalIndustry(String inChemicalIndustry) {
        this.inChemicalIndustry = inChemicalIndustry;
    }

    public String getEmployees() {
        return employees;
    }

    public void setEmployees(String employees) {
        this.employees = employees;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLegalRepresentative() {
        return legalRepresentative;
    }

    public void setLegalRepresentative(String legalRepresentative) {
        this.legalRepresentative = legalRepresentative;
    }

    public String getLegalRepresentativeMobile() {
        return legalRepresentativeMobile;
    }

    public void setLegalRepresentativeMobile(String legalRepresentativeMobile) {
        this.legalRepresentativeMobile = legalRepresentativeMobile;
    }

    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public String getSearchTitle() {
        return searchTitle;
    }

    public void setSearchTitle(String searchTitle) {
        this.searchTitle = searchTitle;
    }

    public String getMajorResponsiblePerson() {
        return majorResponsiblePerson;
    }

    public void setMajorResponsiblePerson(String majorResponsiblePerson) {
        this.majorResponsiblePerson = majorResponsiblePerson;
    }

    public String getMajorResponsiblePersonContact() {
        return majorResponsiblePersonContact;
    }

    public void setMajorResponsiblePersonContact(String majorResponsiblePersonContact) {
        this.majorResponsiblePersonContact = majorResponsiblePersonContact;
    }

    public String getSatetyResponsiblePerson() {
        return satetyResponsiblePerson;
    }

    public void setSatetyResponsiblePerson(String satetyResponsiblePerson) {
        this.satetyResponsiblePerson = satetyResponsiblePerson;
    }

    public String getSatetyResponsiblePersonContact() {
        return satetyResponsiblePersonContact;
    }

    public void setSatetyResponsiblePersonContact(String satetyResponsiblePersonContact) {
        this.satetyResponsiblePersonContact = satetyResponsiblePersonContact;
    }

    public String getUnifiedSocialCreditCode() {
        return unifiedSocialCreditCode;
    }

    public void setUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        this.unifiedSocialCreditCode = unifiedSocialCreditCode;
    }

    public String getTown() {
        return town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getEnterpriseAbbreviation() {
        return enterpriseAbbreviation;
    }

    public void setEnterpriseAbbreviation(String enterpriseAbbreviation) {
        this.enterpriseAbbreviation = enterpriseAbbreviation;
    }

    public String getEnterpriseUnifiedCreditCode() {
        return enterpriseUnifiedCreditCode;
    }

    public void setEnterpriseUnifiedCreditCode(String enterpriseUnifiedCreditCode) {
        this.enterpriseUnifiedCreditCode = enterpriseUnifiedCreditCode;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getMapArea() {
        return mapArea;
    }

    public void setMapArea(String mapArea) {
        this.mapArea = mapArea;
    }

    public String getAdministrativeCode() {
        return administrativeCode;
    }

    public void setAdministrativeCode(String administrativeCode) {
        this.administrativeCode = administrativeCode;
    }

    public String getEnterpriseScale() {
        return enterpriseScale;
    }

    public void setEnterpriseScale(String enterpriseScale) {
        this.enterpriseScale = enterpriseScale;
    }

    public String getEconomicType() {
        return economicType;
    }

    public void setEconomicType(String economicType) {
        this.economicType = economicType;
    }

    public String getIndustryCategory() {
        return industryCategory;
    }

    public void setIndustryCategory(String industryCategory) {
        this.industryCategory = industryCategory;
    }

    public String getIndustryCategories() {
        return industryCategories;
    }

    public void setIndustryCategories(String industryCategories) {
        this.industryCategories = industryCategories;
    }

    public String getRegulatoryClassification() {
        return regulatoryClassification;
    }

    public void setRegulatoryClassification(String regulatoryClassification) {
        this.regulatoryClassification = regulatoryClassification;
    }

    public String getRegulatoryClassificationWhc() {
        return regulatoryClassificationWhc;
    }

    public void setRegulatoryClassificationWhc(String regulatoryClassificationWhc) {
        this.regulatoryClassificationWhc = regulatoryClassificationWhc;
    }

    public String getAreaCovered() {
        return areaCovered;
    }

    public void setAreaCovered(String areaCovered) {
        this.areaCovered = areaCovered;
    }

    public String getEnterprisePlan() {
        return enterprisePlan;
    }

    public void setEnterprisePlan(String enterprisePlan) {
        this.enterprisePlan = enterprisePlan;
    }

    public String getAdministrativeSubordination() {
        return administrativeSubordination;
    }

    public void setAdministrativeSubordination(String administrativeSubordination) {
        this.administrativeSubordination = administrativeSubordination;
    }

    public String getChemicalIndustryName() {
        return chemicalIndustryName;
    }

    public void setChemicalIndustryName(String chemicalIndustryName) {
        this.chemicalIndustryName = chemicalIndustryName;
    }

    public String getHazardousChemicalsWorkers() {
        return hazardousChemicalsWorkers;
    }

    public void setHazardousChemicalsWorkers(String hazardousChemicalsWorkers) {
        this.hazardousChemicalsWorkers = hazardousChemicalsWorkers;
    }

    public String getSpecialOperationWorkers() {
        return specialOperationWorkers;
    }

    public void setSpecialOperationWorkers(String specialOperationWorkers) {
        this.specialOperationWorkers = specialOperationWorkers;
    }

    public String getToxicChemicalsWorkers() {
        return toxicChemicalsWorkers;
    }

    public void setToxicChemicalsWorkers(String toxicChemicalsWorkers) {
        this.toxicChemicalsWorkers = toxicChemicalsWorkers;
    }

    public String getEnterpriseStatus() {
        return enterpriseStatus;
    }

    public void setEnterpriseStatus(String enterpriseStatus) {
        this.enterpriseStatus = enterpriseStatus;
    }

    public String getBuildArea() {
        return buildArea;
    }

    public void setBuildArea(String buildArea) {
        this.buildArea = buildArea;
    }

    public String getLastYearBusinessIncome() {
        return lastYearBusinessIncome;
    }

    public void setLastYearBusinessIncome(String lastYearBusinessIncome) {
        this.lastYearBusinessIncome = lastYearBusinessIncome;
    }

    public String getTotalAssets() {
        return totalAssets;
    }

    public void setTotalAssets(String totalAssets) {
        this.totalAssets = totalAssets;
    }

    public String getDataSourceId() {
        return dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getRegulatoryLittleClassification() {
        return regulatoryLittleClassification;
    }

    public void setRegulatoryLittleClassification(String regulatoryLittleClassification) {
        this.regulatoryLittleClassification = regulatoryLittleClassification;
    }

    public String getDeleted() {
        return deleted;
    }

    public void setDeleted(String deleted) {
        this.deleted = deleted;
    }

    public String getSafetyProductionNumber() {
        return safetyProductionNumber;
    }

    public void setSafetyProductionNumber(String safetyProductionNumber) {
        this.safetyProductionNumber = safetyProductionNumber;
    }

    public String getSafetyProductionStartTime() {
        return safetyProductionStartTime;
    }

    public void setSafetyProductionStartTime(String safetyProductionStartTime) {
        this.safetyProductionStartTime = safetyProductionStartTime;
    }

    public String getSafetyProductionEndTime() {
        return safetyProductionEndTime;
    }

    public void setSafetyProductionEndTime(String safetyProductionEndTime) {
        this.safetyProductionEndTime = safetyProductionEndTime;
    }

    public String getSafeOrganization() {
        return safeOrganization;
    }

    public void setSafeOrganization(String safeOrganization) {
        this.safeOrganization = safeOrganization;
    }

    public String getSupervisionHazardousChemicals() {
        return supervisionHazardousChemicals;
    }

    public void setSupervisionHazardousChemicals(String supervisionHazardousChemicals) {
        this.supervisionHazardousChemicals = supervisionHazardousChemicals;
    }

    public String getHighlyToxicProduce() {
        return highlyToxicProduce;
    }

    public void setHighlyToxicProduce(String highlyToxicProduce) {
        this.highlyToxicProduce = highlyToxicProduce;
    }

    public String getHighRiskTechnology() {
        return highRiskTechnology;
    }

    public void setHighRiskTechnology(String highRiskTechnology) {
        this.highRiskTechnology = highRiskTechnology;
    }

    public String getMajorHazard() {
        return majorHazard;
    }

    public void setMajorHazard(String majorHazard) {
        this.majorHazard = majorHazard;
    }

    public String getMajorHazardLevel() {
        return majorHazardLevel;
    }

    public void setMajorHazardLevel(String majorHazardLevel) {
        this.majorHazardLevel = majorHazardLevel;
    }

    public String getSafetyDutyTelephone() {
        return safetyDutyTelephone;
    }

    public void setSafetyDutyTelephone(String safetyDutyTelephone) {
        this.safetyDutyTelephone = safetyDutyTelephone;
    }

    public String getSafeProductionStandard() {
        return safeProductionStandard;
    }

    public void setSafeProductionStandard(String safeProductionStandard) {
        this.safeProductionStandard = safeProductionStandard;
    }

    public String getSafeProductionPromise() {
        return safeProductionPromise;
    }

    public void setSafeProductionPromise(String safeProductionPromise) {
        this.safeProductionPromise = safeProductionPromise;
    }

    public String getLegalRepresentativePost() {
        return legalRepresentativePost;
    }

    public void setLegalRepresentativePost(String legalRepresentativePost) {
        this.legalRepresentativePost = legalRepresentativePost;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public Date getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(Date establishDate) {
        this.establishDate = establishDate;
    }

    public String getBusinessLicenseType() {
        return businessLicenseType;
    }

    public void setBusinessLicenseType(String businessLicenseType) {
        this.businessLicenseType = businessLicenseType;
    }

    public String getBusinessLicense() {
        return businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public String getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(String registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    public String getBusinessRange() {
        return businessRange;
    }

    public void setBusinessRange(String businessRange) {
        this.businessRange = businessRange;
    }

    public Date getLicenseValidateEndTime() {
        return licenseValidateEndTime;
    }

    public void setLicenseValidateEndTime(Date licenseValidateEndTime) {
        this.licenseValidateEndTime = licenseValidateEndTime;
    }

    public Date getLicenseValidateStartTime() {
        return licenseValidateStartTime;
    }

    public void setLicenseValidateStartTime(Date licenseValidateStartTime) {
        this.licenseValidateStartTime = licenseValidateStartTime;
    }

    public String getManagementOrganization() {
        return managementOrganization;
    }

    public void setManagementOrganization(String managementOrganization) {
        this.managementOrganization = managementOrganization;
    }

    public String getResponsiblePersonPrincipal() {
        return responsiblePersonPrincipal;
    }

    public void setResponsiblePersonPrincipal(String responsiblePersonPrincipal) {
        this.responsiblePersonPrincipal = responsiblePersonPrincipal;
    }

    public String getSafePersonPrincipal() {
        return safePersonPrincipal;
    }

    public void setSafePersonPrincipal(String safePersonPrincipal) {
        this.safePersonPrincipal = safePersonPrincipal;
    }

    public String getSafePersonFullTimeCount() {
        return safePersonFullTimeCount;
    }

    public void setSafePersonFullTimeCount(String safePersonFullTimeCount) {
        this.safePersonFullTimeCount = safePersonFullTimeCount;
    }

    public String getSafePersonPartTimeCount() {
        return safePersonPartTimeCount;
    }

    public void setSafePersonPartTimeCount(String safePersonPartTimeCount) {
        this.safePersonPartTimeCount = safePersonPartTimeCount;
    }

    public String getSafetyDirector() {
        return safetyDirector;
    }

    public void setSafetyDirector(String safetyDirector) {
        this.safetyDirector = safetyDirector;
    }

    public String getSafetyDirectorName() {
        return safetyDirectorName;
    }

    public void setSafetyDirectorName(String safetyDirectorName) {
        this.safetyDirectorName = safetyDirectorName;
    }

    public String getPlanFiling() {
        return planFiling;
    }

    public void setPlanFiling(String planFiling) {
        this.planFiling = planFiling;
    }

    public String getSafetyBusinessLicense() {
        return safetyBusinessLicense;
    }

    public void setSafetyBusinessLicense(String safetyBusinessLicense) {
        this.safetyBusinessLicense = safetyBusinessLicense;
    }

    public String getSafetyProductionPromise() {
        return safetyProductionPromise;
    }

    public void setSafetyProductionPromise(String safetyProductionPromise) {
        this.safetyProductionPromise = safetyProductionPromise;
    }

    public String getSafetyDeclarant() {
        return safetyDeclarant;
    }

    public void setSafetyDeclarant(String safetyDeclarant) {
        this.safetyDeclarant = safetyDeclarant;
    }

    public String getSafetyDeclarantPhone() {
        return safetyDeclarantPhone;
    }

    public void setSafetyDeclarantPhone(String safetyDeclarantPhone) {
        this.safetyDeclarantPhone = safetyDeclarantPhone;
    }

    public Date getSafetyOrgApprovelTime() {
        return safetyOrgApprovelTime;
    }

    public void setSafetyOrgApprovelTime(Date safetyOrgApprovelTime) {
        this.safetyOrgApprovelTime = safetyOrgApprovelTime;
    }

    public String getSafetyOrgApprovelResult() {
        return safetyOrgApprovelResult;
    }

    public void setSafetyOrgApprovelResult(String safetyOrgApprovelResult) {
        this.safetyOrgApprovelResult = safetyOrgApprovelResult;
    }

    public String getInclusionChemicalIndustry() {
        return inclusionChemicalIndustry;
    }

    public void setInclusionChemicalIndustry(String inclusionChemicalIndustry) {
        this.inclusionChemicalIndustry = inclusionChemicalIndustry;
    }

    public String getHazardousChemicals() {
        return hazardousChemicals;
    }

    public void setHazardousChemicals(String hazardousChemicals) {
        this.hazardousChemicals = hazardousChemicals;
    }

    public String getDangerousChemicalsWarehouse() {
        return dangerousChemicalsWarehouse;
    }

    public void setDangerousChemicalsWarehouse(String dangerousChemicalsWarehouse) {
        this.dangerousChemicalsWarehouse = dangerousChemicalsWarehouse;
    }

    public String getDangerousChemicalsPipeline() {
        return dangerousChemicalsPipeline;
    }

    public void setDangerousChemicalsPipeline(String dangerousChemicalsPipeline) {
        this.dangerousChemicalsPipeline = dangerousChemicalsPipeline;
    }

    public String getSupervisionHazardousTechnology() {
        return supervisionHazardousTechnology;
    }

    public void setSupervisionHazardousTechnology(String supervisionHazardousTechnology) {
        this.supervisionHazardousTechnology = supervisionHazardousTechnology;
    }

    public String getEightDangerousOperations() {
        return eightDangerousOperations;
    }

    public void setEightDangerousOperations(String eightDangerousOperations) {
        this.eightDangerousOperations = eightDangerousOperations;
    }

    public String getTradeEnterprisesDangerous() {
        return tradeEnterprisesDangerous;
    }

    public void setTradeEnterprisesDangerous(String tradeEnterprisesDangerous) {
        this.tradeEnterprisesDangerous = tradeEnterprisesDangerous;
    }

    public String getOccupationalHazards() {
        return occupationalHazards;
    }

    public void setOccupationalHazards(String occupationalHazards) {
        this.occupationalHazards = occupationalHazards;
    }

    public String getLimitedSpace() {
        return limitedSpace;
    }

    public void setLimitedSpace(String limitedSpace) {
        this.limitedSpace = limitedSpace;
    }

    public String getAmmoniaRefrigeration() {
        return ammoniaRefrigeration;
    }

    public void setAmmoniaRefrigeration(String ammoniaRefrigeration) {
        this.ammoniaRefrigeration = ammoniaRefrigeration;
    }

    public String getCombustibleDust() {
        return combustibleDust;
    }

    public void setCombustibleDust(String combustibleDust) {
        this.combustibleDust = combustibleDust;
    }

    public String getMetalSmelting() {
        return metalSmelting;
    }

    public void setMetalSmelting(String metalSmelting) {
        this.metalSmelting = metalSmelting;
    }

    public String getSpecialOperation() {
        return specialOperation;
    }

    public void setSpecialOperation(String specialOperation) {
        this.specialOperation = specialOperation;
    }

    public String getFactoryInFactory() {
        return factoryInFactory;
    }

    public void setFactoryInFactory(String factoryInFactory) {
        this.factoryInFactory = factoryInFactory;
    }

    public String getDeepWellCasting() {
        return deepWellCasting;
    }

    public void setDeepWellCasting(String deepWellCasting) {
        this.deepWellCasting = deepWellCasting;
    }

    public String getDustAndExplosion() {
        return dustAndExplosion;
    }

    public void setDustAndExplosion(String dustAndExplosion) {
        this.dustAndExplosion = dustAndExplosion;
    }

    public String getSteelIndustry() {
        return steelIndustry;
    }

    public void setSteelIndustry(String steelIndustry) {
        this.steelIndustry = steelIndustry;
    }

    public String getEmployeesCount() {
        return employeesCount;
    }

    public void setEmployeesCount(String employeesCount) {
        this.employeesCount = employeesCount;
    }

    public String getProductionStaffCount() {
        return productionStaffCount;
    }

    public void setProductionStaffCount(String productionStaffCount) {
        this.productionStaffCount = productionStaffCount;
    }

    public String getEnterpriseTeamLeaderCount() {
        return enterpriseTeamLeaderCount;
    }

    public void setEnterpriseTeamLeaderCount(String enterpriseTeamLeaderCount) {
        this.enterpriseTeamLeaderCount = enterpriseTeamLeaderCount;
    }

    public String getSpecialOperationPersonnelCount() {
        return specialOperationPersonnelCount;
    }

    public void setSpecialOperationPersonnelCount(String specialOperationPersonnelCount) {
        this.specialOperationPersonnelCount = specialOperationPersonnelCount;
    }

    public String getBachelorDegreeCount() {
        return bachelorDegreeCount;
    }

    public void setBachelorDegreeCount(String bachelorDegreeCount) {
        this.bachelorDegreeCount = bachelorDegreeCount;
    }

    public String getJuniorCollegeCount() {
        return juniorCollegeCount;
    }

    public void setJuniorCollegeCount(String juniorCollegeCount) {
        this.juniorCollegeCount = juniorCollegeCount;
    }

    public String getHighSchoolCount() {
        return highSchoolCount;
    }

    public void setHighSchoolCount(String highSchoolCount) {
        this.highSchoolCount = highSchoolCount;
    }

    public String getJuniorMiddleSchoolCount() {
        return juniorMiddleSchoolCount;
    }

    public void setJuniorMiddleSchoolCount(String juniorMiddleSchoolCount) {
        this.juniorMiddleSchoolCount = juniorMiddleSchoolCount;
    }

    public String getUnderJuniorMiddleSchoolCount() {
        return underJuniorMiddleSchoolCount;
    }

    public void setUnderJuniorMiddleSchoolCount(String underJuniorMiddleSchoolCount) {
        this.underJuniorMiddleSchoolCount = underJuniorMiddleSchoolCount;
    }

    public String getReceivedVocationalCount() {
        return receivedVocationalCount;
    }

    public void setReceivedVocationalCount(String receivedVocationalCount) {
        this.receivedVocationalCount = receivedVocationalCount;
    }

    public String getReceivingSkillCount() {
        return receivingSkillCount;
    }

    public void setReceivingSkillCount(String receivingSkillCount) {
        this.receivingSkillCount = receivingSkillCount;
    }

    public String getMigrantWorkersCount() {
        return migrantWorkersCount;
    }

    public void setMigrantWorkersCount(String migrantWorkersCount) {
        this.migrantWorkersCount = migrantWorkersCount;
    }

    public String getLaborDispatchWorkers() {
        return laborDispatchWorkers;
    }

    public void setLaborDispatchWorkers(String laborDispatchWorkers) {
        this.laborDispatchWorkers = laborDispatchWorkers;
    }

    public String getThreeYearsAverageWorkers() {
        return threeYearsAverageWorkers;
    }

    public void setThreeYearsAverageWorkers(String threeYearsAverageWorkers) {
        this.threeYearsAverageWorkers = threeYearsAverageWorkers;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getDataVersion() {
        return dataVersion;
    }

    public void setDataVersion(String dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String getEmployExpert() {
        return employExpert;
    }

    public void setEmployExpert(String employExpert) {
        this.employExpert = employExpert;
    }

    public String getEmployTechServiceOrg() {
        return employTechServiceOrg;
    }

    public void setEmployTechServiceOrg(String employTechServiceOrg) {
        this.employTechServiceOrg = employTechServiceOrg;
    }

    public String getDangerChemicalLevel() {
        return dangerChemicalLevel;
    }

    public void setDangerChemicalLevel(String dangerChemicalLevel) {
        this.dangerChemicalLevel = dangerChemicalLevel;
    }

    public String getSafetyProductStandardLevel() {
        return safetyProductStandardLevel;
    }

    public void setSafetyProductStandardLevel(String safetyProductStandardLevel) {
        this.safetyProductStandardLevel = safetyProductStandardLevel;
    }

    public String getKeyRegulatoryArea() {
        return keyRegulatoryArea;
    }

    public void setKeyRegulatoryArea(String keyRegulatoryArea) {
        this.keyRegulatoryArea = keyRegulatoryArea;
    }

    public String getEnterpriseLevel() {
        return enterpriseLevel;
    }

    public void setEnterpriseLevel(String enterpriseLevel) {
        this.enterpriseLevel = enterpriseLevel;
    }

    public String getMoveSupervise() {
        return moveSupervise;
    }

    public void setMoveSupervise(String moveSupervise) {
        this.moveSupervise = moveSupervise;
    }

    public String getMoveSuperviseReason() {
        return moveSuperviseReason;
    }

    public void setMoveSuperviseReason(String moveSuperviseReason) {
        this.moveSuperviseReason = moveSuperviseReason;
    }

    public String getRegisterSafetyEngineerNum() {
        return registerSafetyEngineerNum;
    }

    public void setRegisterSafetyEngineerNum(String registerSafetyEngineerNum) {
        this.registerSafetyEngineerNum = registerSafetyEngineerNum;
    }

    public String getSafetyProductStandardExplain() {
        return safetyProductStandardExplain;
    }

    public void setSafetyProductStandardExplain(String safetyProductStandardExplain) {
        this.safetyProductStandardExplain = safetyProductStandardExplain;
    }

    public String getSafetyManageDeptName() {
        return safetyManageDeptName;
    }

    public void setSafetyManageDeptName(String safetyManageDeptName) {
        this.safetyManageDeptName = safetyManageDeptName;
    }

    public String getDeclarant() {
        return declarant;
    }

    public void setDeclarant(String declarant) {
        this.declarant = declarant;
    }

    public String getDeclarantPhone() {
        return declarantPhone;
    }

    public void setDeclarantPhone(String declarantPhone) {
        this.declarantPhone = declarantPhone;
    }

    public Date getApprovelTime() {
        return approvelTime;
    }

    public void setApprovelTime(Date approvelTime) {
        this.approvelTime = approvelTime;
    }

    public String getApprovelResult() {
        return approvelResult;
    }

    public void setApprovelResult(String approvelResult) {
        this.approvelResult = approvelResult;
    }

    public String getMedicineIndustry() {
        return medicineIndustry;
    }

    public void setMedicineIndustry(String medicineIndustry) {
        this.medicineIndustry = medicineIndustry;
    }

    public String getFireworksIndustry() {
        return fireworksIndustry;
    }

    public void setFireworksIndustry(String fireworksIndustry) {
        this.fireworksIndustry = fireworksIndustry;
    }

    public String getChemicalIndustry() {
        return chemicalIndustry;
    }

    public void setChemicalIndustry(String chemicalIndustry) {
        this.chemicalIndustry = chemicalIndustry;
    }

    public String getSuperviseDept() {
        return superviseDept;
    }

    public void setSuperviseDept(String superviseDept) {
        this.superviseDept = superviseDept;
    }

    public String getVideoMonitor() {
        return videoMonitor;
    }

    public void setVideoMonitor(String videoMonitor) {
        this.videoMonitor = videoMonitor;
    }

    public String getSensorMonitor() {
        return sensorMonitor;
    }

    public void setSensorMonitor(String sensorMonitor) {
        this.sensorMonitor = sensorMonitor;
    }

    public String getCitySupervision() {
        return citySupervision;
    }

    public void setCitySupervision(String citySupervision) {
        this.citySupervision = citySupervision;
    }

    public String getLegalRepresentativeGender() {
        return legalRepresentativeGender;
    }

    public void setLegalRepresentativeGender(String legalRepresentativeGender) {
        this.legalRepresentativeGender = legalRepresentativeGender;
    }

    public String getLegalRepresentativeAge() {
        return legalRepresentativeAge;
    }

    public void setLegalRepresentativeAge(String legalRepresentativeAge) {
        this.legalRepresentativeAge = legalRepresentativeAge;
    }

    public String getEnterpriseCreditGrade() {
        return enterpriseCreditGrade;
    }

    public void setEnterpriseCreditGrade(String enterpriseCreditGrade) {
        this.enterpriseCreditGrade = enterpriseCreditGrade;
    }

    public Date getOdmRksj() {
        return odmRksj;
    }

    public void setOdmRksj(Date odmRksj) {
        this.odmRksj = odmRksj;
    }

    public Integer getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }
}
