package com.eazytec.hkydatabasessynchronization.config;

import com.eazytec.hkydatabasessynchronization.event.*;
import com.eazytec.hkydatabasessynchronization.utils.DataSourceNameConstant;
import com.gitee.Jmysy.binlog4j.core.*;
import io.quarkus.agroal.runtime.DataSourcesJdbcRuntimeConfig;
import io.quarkus.arc.Unremovable;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.runtime.Startup;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

import java.net.URI;
import java.util.Map;
import java.util.Optional;

@ApplicationScoped
public class BinlogConfig {

    @Inject
    DataSourcesRuntimeConfig dataSourcesRuntimeConfig;

    @Inject
    DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig;

    @Inject
    EnterpriseBaseInfoEvent enterpriseBaseInfoEvent;

    @Inject
    EnterpriseRescueMaterialEvent enterpriseRescueMaterialEvent;

    @Inject
    EnterpriseRescueTeamEvent enterpriseRescueTeamEvent;

    @Inject
    EnterpriseTestReportEvent enterpriseTestReportEvent;

    @Inject
    EOTEmerspsSpsEnterpriseMajorHazardEvent eotEmerspsSpsEnterpriseMajorHazardEvent;

    @Inject
    OT12345SysAreaEvent ot12345SysAreaEvent;

    @Inject
    OT12345SysGroupDataEvent ot12345SysGroupDataEvent;

    @Inject
    OT12345TBusiAdviceEvent ot12345TBusiAdviceEvent;

    @Inject
    OT12345TBusiFormEvent ot12345TBusiFormEvent;

    @Inject
    OTBaseAjqyEvent otBaseAjqyEvent;

    @Inject
    OTBaseIstProjectEvent otBaseIstProjectEvent;

    @Inject
    OTBaseJiyueMapQiyeEvent otBaseJiyueMapQiyeEvent;

    @Inject
    OTEmerspsEmeCdeCodeDictoTEmerspsEmeCdeCodeDictEvent otEmerspsEmeCdeCodeDictoTEmerspsEmeCdeCodeDictEvent;

    @Inject
    OTEmerspsSpsEnterpriseEvaluationTestReportEvent otEmerspsSpsEnterpriseEvaluationTestReportEvent;

    @Inject
    OTEmerspsSpsEnterpriseHazardousChemicalsEvent otEmerspsSpsEnterpriseHazardousChemicalsEvent;

    @Inject
    OTEmerspsSpsEnterpriseHistoryHiddenTroubleEvent otEmerspsSpsEnterpriseHistoryHiddenTroubleEvent;

    @Inject
    OTEmerspsSpsEnterpriseLeakPointEvent otEmerspsSpsEnterpriseLeakPointEvent;

    @Inject
    OTEmerspsSpsEnterpriseMaterialInfoEvent otEmerspsSpsEnterpriseMaterialInfoEvent;

    @Inject
    OTEmerspsSpsEnterpriseRealtimeAlarmRecordEvent otEmerspsSpsEnterpriseRealtimeAlarmRecordEvent;

    @Inject
    OTEmerspsSpsEnterpriseRiskIdentificationEvent otEmerspsSpsEnterpriseRiskIdentificationEvent;

    @Inject
    OTEmerspsSpsEnterpriseRiskPartitionEvent otEmerspsSpsEnterpriseRiskPartitionEvent;

    @Inject
    OTEmerspsSpsEnterpriseSpecialOperationPersonEvent otEmerspsSpsEnterpriseSpecialOperationPersonEvent;

    @Inject
    OTEmerspsSpsSpSysCodeEvent otEmerspsSpsSpSysCodeEvent;

    @Inject
    OTGaTJxwCzrkxxEvent otGaTJxwCzrkxxEvent;

    @Inject
    OTGxjCydnJiyueMapDikuaiEvent otGxjCydnJiyueMapDikuaiEvent;

    @Inject
    OTSthjTAirCityHourForecastEvent otThjTAirCityHourForecastEvent;

    @Inject
    OTSthjTAirStationBaseinfoEvent otThjTAirStationBaseinfoEvent;

    @Inject
    OTSthjTAirStationDayZhEvent otSthjTAirStationDayZhEvent;

    @Inject
    OTSthjTAirStationHourZhEvent otSthjTAirStationHourZhEvent;

    @Inject
    OTSthjTWaterStationBaseinfoEvent otThjTWaterStationBaseinfoEvent;

    @Inject
    OTSthjTWaterStationDayZhEvent otThjTWaterStationDayZhEvent;

    @Inject
    OTSthjTWaterStationHourZhEvent otThjTWaterStationHourZhEvent;

    @Inject
    OTSyrkEvent otSyrkEvent;

    @Inject
    OTWghsjTRyjcxxbEvent otTWghsjTRyjcxxbEvent;

    @Inject
    OTYqydEnterpriseEvent otYqydEnterpriseEvent;

    @Inject
    PartyActivityEvent partyActivityEvent;

    @Inject
    PartyDictEvent partyDictEvent;

    @Inject
    PartyMemberEvent partyMemberEvent;

    @Inject
    PartyOrganizationEvent partyOrganizationEvent;

    @Inject
    TProjectEvent tProjectEvent;

    @Inject
    TProjectJgEvent tProjectJgEvent;

    @Inject
    TProjectNjEvent tProjectNjEvent;

    @Inject
    TProjectScheduleEvent tProjectScheduleEvent;

    @Inject
    TProjectZjEvent tProjectZjEvent;

    @Singleton
    @Unremovable
    @Startup
    public IBinlogClient binlogClient() {
        DataSourceRuntimeConfig fromDataSourceRuntimeConfig = dataSourcesRuntimeConfig.dataSources().get(DataSourceNameConstant.FROM_DB);
        Map<String, DataSourcesJdbcRuntimeConfig.DataSourceJdbcOuterNamedRuntimeConfig> dataSources = dataSourcesJdbcRuntimeConfig.dataSources();
        DataSourcesJdbcRuntimeConfig.DataSourceJdbcOuterNamedRuntimeConfig fromDataSourceConfig = dataSources.get(DataSourceNameConstant.FROM_DB);
        Optional<String> urlOptional = fromDataSourceConfig.jdbc().url();
        String cleanURI = urlOptional.get().substring(5);
        URI uri = URI.create(cleanURI);
        BinlogClientConfig clientConfig = new BinlogClientConfig();
        clientConfig.setHost(uri.getHost());
        clientConfig.setPort(uri.getPort());
        clientConfig.setUsername(fromDataSourceRuntimeConfig.username().get());
        clientConfig.setPassword(fromDataSourceRuntimeConfig.password().get());
        clientConfig.setServerId(1);
        IBinlogClient binlogClient = new BinlogClient(clientConfig);
        binlogClient.registerEventHandler(enterpriseBaseInfoEvent);
        binlogClient.registerEventHandler(enterpriseRescueMaterialEvent);
        binlogClient.registerEventHandler(enterpriseRescueTeamEvent);
        binlogClient.registerEventHandler(enterpriseTestReportEvent);
        binlogClient.registerEventHandler(eotEmerspsSpsEnterpriseMajorHazardEvent);
        binlogClient.registerEventHandler(ot12345SysAreaEvent);
        binlogClient.registerEventHandler(ot12345SysGroupDataEvent);
        binlogClient.registerEventHandler(ot12345TBusiAdviceEvent);
        binlogClient.registerEventHandler(ot12345TBusiFormEvent);
        binlogClient.registerEventHandler(otBaseAjqyEvent);
        binlogClient.registerEventHandler(otBaseIstProjectEvent);
        binlogClient.registerEventHandler(otBaseJiyueMapQiyeEvent);
        binlogClient.registerEventHandler(otEmerspsEmeCdeCodeDictoTEmerspsEmeCdeCodeDictEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseEvaluationTestReportEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseHazardousChemicalsEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseHistoryHiddenTroubleEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseLeakPointEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseMaterialInfoEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseRealtimeAlarmRecordEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseRiskIdentificationEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseRiskPartitionEvent);
        binlogClient.registerEventHandler(otEmerspsSpsEnterpriseSpecialOperationPersonEvent);
        binlogClient.registerEventHandler(otEmerspsSpsSpSysCodeEvent);
        binlogClient.registerEventHandler(otGaTJxwCzrkxxEvent);
        binlogClient.registerEventHandler(otGxjCydnJiyueMapDikuaiEvent);
        binlogClient.registerEventHandler(otThjTAirCityHourForecastEvent);
        binlogClient.registerEventHandler(otThjTAirStationBaseinfoEvent);
        binlogClient.registerEventHandler(otSthjTAirStationDayZhEvent);
        binlogClient.registerEventHandler(otSthjTAirStationHourZhEvent);
        binlogClient.registerEventHandler(otThjTWaterStationBaseinfoEvent);
        binlogClient.registerEventHandler(otThjTWaterStationDayZhEvent);
        binlogClient.registerEventHandler(otThjTWaterStationHourZhEvent);
        binlogClient.registerEventHandler(otSyrkEvent);
        binlogClient.registerEventHandler(otTWghsjTRyjcxxbEvent);
        binlogClient.registerEventHandler(otYqydEnterpriseEvent);
        binlogClient.registerEventHandler(partyActivityEvent);
        binlogClient.registerEventHandler(partyDictEvent);
        binlogClient.registerEventHandler(partyMemberEvent);
        binlogClient.registerEventHandler(partyOrganizationEvent);
        binlogClient.registerEventHandler(tProjectEvent);
        binlogClient.registerEventHandler(tProjectJgEvent);
        binlogClient.registerEventHandler(tProjectNjEvent);
        binlogClient.registerEventHandler(tProjectScheduleEvent);
        binlogClient.registerEventHandler(tProjectZjEvent);
        binlogClient.connect();
        return binlogClient;
    }
}
