import org.jetbrains.kotlin.gradle.dsl.JvmTarget

plugins {
    alias(libs.plugins.kotlinMultiplatform)
    alias(libs.plugins.androidApplication)
}

kotlin {
    // 让 Kotlin 使用 JDK 17 运行编译任务
    jvmToolchain(17)
    androidTarget()

    ohosArm64 {
        binaries {
            sharedLib {
                baseName = "kn"
            }
        }
    }

    listOf(
        iosArm64(),
        iosSimulatorArm64()
    ).forEach { iosTarget ->
        iosTarget.binaries.framework {
            baseName = "ComposeApp"
            isStatic = true
        }
    }

    sourceSets {
        val commonMain by getting
        val iosMain by creating {
            dependsOn(commonMain)
            dependencies {
                implementation(project(":lib-arith"))
            }
        }
    
        val iosSimulatorArm64Main by getting {
            dependsOn(iosMain)
        }

        val ohosArm64Main by getting {
            dependsOn(commonMain)
            dependencies {
                implementation(project(":lib-arith"))
            }
        }

        androidMain.dependencies {
            implementation(libs.androidx.activity.compose)
            implementation(project(":lib-arith"))
        }
        commonMain.dependencies {
            // 保持为空：不在 commonMain 引入 lib-arith
        }
        commonTest.dependencies {
            implementation(libs.kotlin.test)
        }
    }
}

android {
    namespace = "com.example.testdemo"
    compileSdk = libs.versions.android.compileSdk.get().toInt()

    defaultConfig {
        applicationId = "com.example.testdemo"
        minSdk = libs.versions.android.minSdk.get().toInt()
        targetSdk = libs.versions.android.targetSdk.get().toInt()
        versionCode = 1
        versionName = "1.0"
    }
    packaging {
        resources {
            excludes += "/META-INF/{AL2.0,LGPL2.1}"
        }
    }
    buildTypes {
        getByName("release") {
            isMinifyEnabled = false
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
}

dependencies {
    // 移除 Compose 调试工具
}

arrayOf("debug", "release").forEach { type ->
    val capitalizedType = type.replaceFirstChar { it.uppercase() }
    tasks.register<Copy>("publish${capitalizedType}BinariesToHarmonyApp") {
        group = "harmony"
        dependsOn("link${capitalizedType}SharedOhosArm64")
        into(rootProject.file("harmonyApp"))
        val binaryPath = "build/bin/ohosArm64/${type}Shared"
        from("$binaryPath/libkn_api.h") {
            into("entry/src/main/cpp/include/")
        }
        from("$binaryPath/libkn.so") {
            into("entry/libs/arm64-v8a/")
        }
        doFirst {
            if (!file(binaryPath).exists()) {
                throw GradleException("未找到产物目录: $binaryPath")
            }
        }
    }
}
