import org.jetbrains.kotlin.gradle.dsl.JvmTarget

plugins {
    alias(libs.plugins.kotlinMultiplatform)
    alias(libs.plugins.androidApplication)
}

kotlin {
    androidTarget {
        compilerOptions {
            jvmTarget.set(JvmTarget.JVM_11)
        }
    }

    ohosArm64 {
        binaries {
            sharedLib {
                // 注意：这里的 baseName 必须与你 publish 任务中引用的文件名对应
                // 如果你 publish 任务里写的是 libkn.so，这里 baseName 应该是 "kn"
                baseName = "kn"
            }
        }
    }

    listOf(
        iosArm64(),
        iosSimulatorArm64()
    ).forEach { iosTarget ->
        iosTarget.binaries.framework {
            baseName = "ComposeApp"
            isStatic = true
        }
    }

    sourceSets {
        androidMain.dependencies {
            implementation(libs.androidx.activity.compose)
            implementation(project(":lib-arith"))
        }
        commonMain.dependencies {
        }
        commonTest.dependencies {
            implementation(libs.kotlin.test)
        }
        val ohosArm64Main by getting {
            dependsOn(commonMain.get())
        }
    }
}

android {
    namespace = "com.example.testdemo"
    compileSdk = libs.versions.android.compileSdk.get().toInt()

    defaultConfig {
        applicationId = "com.example.testdemo"
        minSdk = libs.versions.android.minSdk.get().toInt()
        targetSdk = libs.versions.android.targetSdk.get().toInt()
        versionCode = 1
        versionName = "1.0"
    }
    packaging {
        resources {
            excludes += "/META-INF/{AL2.0,LGPL2.1}"
        }
    }
    buildTypes {
        getByName("release") {
            isMinifyEnabled = false
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
}

dependencies {
    // 移除 Compose 调试工具
}

arrayOf("debug", "release").forEach { type ->
    val capitalizedType = type.replaceFirstChar { it.uppercase() }
    tasks.register<Copy>("publish${capitalizedType}BinariesToHarmonyApp") {
        group = "harmony"
        dependsOn("link${capitalizedType}SharedOhosArm64")
        into(rootProject.file("harmonyApp"))
        val binaryPath = "build/bin/ohosArm64/${type}Shared"
        from("$binaryPath/libkn_api.h") {
            into("entry/src/main/cpp/include/")
        }
        from("$binaryPath/libkn.so") {
            into("entry/libs/arm64-v8a/")
        }
        doFirst {
            if (!file(binaryPath).exists()) {
                throw GradleException("未找到产物目录: $binaryPath")
            }
        }
    }
}
