plugins {
    id("org.jetbrains.kotlin.multiplatform")
    id("com.android.library")
}

kotlin {
    // 统一使用 JDK 17 作为工具链
    jvmToolchain(17)
    androidTarget()
    iosArm64()
    iosSimulatorArm64()
    iosX64()
    ohosArm64()

    sourceSets {
        val commonMain by getting
        val androidMain by getting
        val iosMain by creating { dependsOn(commonMain) }
        val iosArm64Main by getting { dependsOn(iosMain) }
        val iosSimulatorArm64Main by getting { dependsOn(iosMain) }
        val iosX64Main by getting { dependsOn(iosMain) }
        val ohosArm64Main by getting { dependsOn(commonMain) }
    }
}

android {
    namespace = "com.example.arith"
    compileSdk = 34
    defaultConfig { minSdk = 24 }
}