# Python开发环境

这是一个基于Dev Container的Python开发环境配置。

## 特性

- **Python 3.11**: 最新的稳定版本
- **代码质量工具**: 
  - Black (代码格式化)
  - Flake8 (代码检查)
  - MyPy (类型检查)
  - Pylint (代码分析)
- **测试框架**: Pytest
- **开发工具**: IPython, Jupyter
- **Shell环境**: Zsh + Oh My Zsh

## 使用方法

1. 在VS Code中打开此项目
2. 当提示时，选择"在容器中重新打开"
3. 等待容器构建完成
4. 运行 `hello.py` 文件查看Hello World示例

## 运行Hello World

```bash
python hello.py
```

## 安装依赖

```bash
pip install -r requirements.txt
```

## 代码格式化

```bash
black .
```

## 代码检查

```bash
flake8 .
mypy .
pylint .
```

## 运行测试

```bash
pytest
```

## 文件结构

```
.
├── .devcontainer/
│   └── devcontainer.json    # Dev Container配置
├── hello.py                 # Hello World示例程序
├── requirements.txt         # Python依赖
└── README.md               # 项目说明
```

## 扩展功能

这个环境包含了以下VS Code扩展：
- Python语言支持
- Python调试器
- 代码格式化
- 代码检查
- 类型检查
- 测试支持
