# 🚀 Node.js Hello World 项目

一个功能完整的 Node.js Hello World 应用，展示了基本的 HTTP 服务器创建、路由处理和响应返回。

## ✨ 特性

- 🌐 内置 HTTP 服务器
- 🎨 美观的 HTML 界面
- 📡 RESTful API 端点
- 🔧 完整的 JSDoc 注释
- 🚀 优雅的服务器关闭处理
- 📱 响应式设计
- 🌍 中文界面支持

## 🛠️ 技术栈

- **Node.js** - JavaScript 运行时
- **原生 HTTP 模块** - 无需额外依赖
- **ES6+ 语法** - 现代 JavaScript 特性
- **JSDoc** - 代码文档注释

## 📋 系统要求

- Node.js 14.0.0 或更高版本
- npm 或 yarn 包管理器

## 🚀 快速开始

### 1. 克隆项目

```bash
git clone <your-repository-url>
cd node-hello-world
```

### 2. 安装依赖

```bash
# 使用 npm
npm install

# 或使用 yarn
yarn install

# 或使用 pnpm
pnpm install
```

### 3. 启动应用

```bash
# 生产环境启动
npm start

# 开发环境启动（支持热重载）
npm run dev
```

### 4. 访问应用

打开浏览器访问 [http://localhost:3000](http://localhost:3000)

## 📡 API 端点

| 端点 | 方法 | 描述 | 响应格式 |
|------|------|------|----------|
| `/` | GET | 主页面，显示项目信息和状态 | HTML |
| `/api/hello` | GET | 返回 Hello World 消息 | JSON |
| `/api/status` | GET | 返回服务器状态信息 | JSON |

### API 响应示例

#### GET /api/hello
```json
{
  "message": "Hello World!",
  "timestamp": "2024-01-01T00:00:00.000Z",
  "language": "zh-CN"
}
```

#### GET /api/status
```json
{
  "status": "running",
  "uptime": 123.456,
  "memory": {
    "rss": 12345678,
    "heapTotal": 12345678,
    "heapUsed": 12345678,
    "external": 123456
  },
  "platform": "linux",
  "nodeVersion": "v18.17.0"
}
```

## 🎯 项目结构

```
node-hello-world/
├── index.js          # 主应用文件
├── package.json      # 项目配置和依赖
├── README.md         # 项目说明文档
└── .devcontainer/    # Dev Container 配置
    └── devcontainer-node-20.json
```

## 🔧 开发

### 可用的 npm 脚本

```bash
npm start      # 启动应用
npm run dev    # 开发模式启动（支持热重载）
npm test       # 运行测试（待实现）
```

### 环境变量

| 变量名 | 默认值 | 描述 |
|--------|--------|------|
| `PORT` | `3000` | 服务器监听端口 |

### 开发模式

开发模式使用 `nodemon` 实现热重载，当你修改代码时，服务器会自动重启：

```bash
npm run dev
```

## 🐳 Docker 支持

项目包含 Dev Container 配置，可以在 VS Code 或 GitHub Codespaces 中直接运行：

1. 安装 VS Code 的 Dev Containers 扩展
2. 在项目根目录按 `Ctrl+Shift+P`（或 `Cmd+Shift+P`）
3. 选择 "Dev Containers: Reopen in Container"
4. 等待容器构建完成

## 📝 代码规范

- 使用 JSDoc 注释规范
- 遵循 ESLint 规则
- 使用 Prettier 进行代码格式化
- 支持 TypeScript 类型检查

## 🧪 测试

```bash
# 运行测试（待实现）
npm test

# 测试覆盖率（待实现）
npm run test:coverage
```

## 📦 构建和部署

### 构建

```bash
# 构建生产版本（待实现）
npm run build
```

### 部署

项目可以部署到各种平台：

- **Heroku**: 支持开箱即用
- **Vercel**: 支持 Node.js 应用
- **Railway**: 简单部署
- **Docker**: 容器化部署

## 🤝 贡献

欢迎提交 Issue 和 Pull Request！

### 贡献指南

1. Fork 项目
2. 创建特性分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 打开 Pull Request

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 🙏 致谢

- [Node.js](https://nodejs.org/) - JavaScript 运行时
- [Dev Containers](https://containers.dev/) - 开发容器支持
- [VS Code](https://code.visualstudio.com/) - 优秀的代码编辑器

## 📞 联系方式

如有问题或建议，请通过以下方式联系：

- 提交 GitHub Issue
- 发送邮件至 [your-email@example.com]
- 项目主页：[项目 URL]

---

**享受编码的乐趣！** 🎉
