import { defineConfig } from 'vite'

/**
 * Vite 配置文件
 * 用于开发环境的热重载和构建优化
 */
export default defineConfig({
  // 开发服务器配置
  server: {
    host: '0.0.0.0',
    port: parseInt(process.env.APP_PORT_1) || 5173,
    open: true,
    cors: true
  },
  
  // 构建配置
  build: {
    outDir: 'dist',
    assetsDir: 'assets',
    sourcemap: true,
    minify: 'terser',
    rollupOptions: {
      output: {
        manualChunks: {
          'three': ['three']
        }
      }
    }
  },
  
  // 优化配置
  optimizeDeps: {
    include: ['three']
  },
  
  // 别名配置
  resolve: {
    alias: {
      '@': '/src'
    }
  }
})
