# Three.js 项目模板

一个功能完整的 Three.js 项目模板，包含基础 3D 场景、光照系统、材质、交互控制和容器化部署支持。

## 🚀 特性

- ✨ **完整的 3D 场景**: 包含9种几何体、完整光照系统和材质
- 🎮 **交互控制**: 鼠标拖拽旋转、滚轮缩放、点击交互
- 🎨 **现代 UI**: 响应式设计，美观的加载动画和信息面板
- 📊 **实时统计**: FPS、物体数量、顶点数量实时显示
- 🐳 **容器化支持**: 完整的 Docker 配置和部署脚本
- 📱 **响应式设计**: 支持移动端和桌面端
- 🔧 **开发友好**: 完整的构建工具链和开发环境

## 📁 项目结构

```
three.js-template/
├── index.html          # 主页面
├── main.js             # Three.js 主逻辑
├── styles.css          # 样式文件
├── package.json        # 项目配置
├── Dockerfile          # Docker 配置
├── docker-entrypoint.sh # Docker 启动脚本
├── Makefile            # 构建脚本
└── README.md           # 项目说明
```

## 🛠️ 技术栈

- **Three.js**: 3D 图形库
- **JavaScript ES6+**: 现代 JavaScript 语法
- **CSS3**: 现代样式和动画
- **Docker**: 容器化部署
- **Node.js**: 运行时环境

## 🚀 快速开始

### 方式一：本地开发

1. **克隆项目**
```bash
git clone https://gitlab.eazytec-cloud.com/eazy-template/three.js-template.git
cd three.js-template
```

2. **安装依赖**
```bash
make install
```

3. **启动开发服务器**
```bash
make run
```

4. **访问应用**
打开浏览器访问 `http://localhost:8000`

### 方式二：Docker 部署

1. **构建镜像**
```bash
make docker-build
```

2. **运行容器**
```bash
make docker-run
```

3. **访问应用**
打开浏览器访问 `http://localhost:8000`

## 🎮 控制说明

| 操作 | 说明 |
|------|------|
| 鼠标左键拖拽 | 旋转视角 |
| 鼠标滚轮 | 缩放场景 |
| 鼠标右键拖拽 | 平移视角 |
| 点击物体 | 查看物体信息 |

## 📋 可用命令

### 基本命令

```bash
make install     # 安装项目依赖
make run         # 启动应用服务器（生产模式）
make stop        # 停止应用服务器
make clean       # 清理项目文件
```

## 🔧 自定义配置

### 修改端口

使用环境变量配置端口：

```bash
export APP_PORT_1=9000
make run
```

### 添加新的几何体

在 `main.js` 的 `createGeometry()` 方法中添加：

```javascript
{
  type: 'your-geometry',
  position: [x, y, z],
  color: 0xhexcolor
}
```

### 自定义光照

在 `createLights()` 方法中修改光照参数：

```javascript
const directionalLight = new THREE.DirectionalLight(0xffffff, 1);
directionalLight.position.set(10, 10, 5);
```

## 📊 性能优化

### 几何体优化

- 使用 `BufferGeometry` 减少内存占用
- 合并相似几何体减少绘制调用
- 使用 LOD（细节层次）系统

### 材质优化

- 使用 `MeshBasicMaterial` 用于简单场景
- 合并材质减少状态切换
- 使用纹理压缩

### 渲染优化

- 启用视锥体剔除
- 使用遮挡剔除
- 合理设置阴影质量和范围

## 🐛 故障排除

### 常见问题

1. **依赖安装失败**
```bash
make clean
make install
```

2. **端口被占用**
```bash
# 查看端口占用
lsof -i :8000
# 杀死进程
kill -9 <PID>
```

3. **应用无法启动**
```bash
make stop
make run
```

### 性能问题

1. **帧率过低**
   - 减少几何体复杂度
   - 降低阴影质量
   - 减少同时渲染的物体数量

2. **内存占用过高**
   - 使用几何体合并
   - 及时释放不需要的资源
   - 使用纹理压缩

## 📚 学习资源

- [Three.js 官方文档](https://threejs.org/docs/)
- [Three.js 示例](https://threejs.org/examples/)
- [WebGL 基础教程](https://webglfundamentals.org/)
- [3D 数学基础](https://www.khanacademy.org/math/geometry-home)

## 🤝 贡献

欢迎提交 Issue 和 Pull Request 来改进这个模板！

## 📄 许可证

MIT License - 详见 [LICENSE](LICENSE) 文件

## 🎯 下一步

- [ ] 添加更多几何体类型
- [ ] 实现纹理加载
- [ ] 添加音频支持
- [ ] 实现场景切换
- [ ] 添加 VR/AR 支持

---

**享受 Three.js 开发的乐趣！** 🎉
