# Rust Hello World 应用

基于 Rust 1.89.0 和 Actix Web 框架的简单 Web 应用模板。

## 项目特性

- 🦀 **Rust 1.89.0** - 使用最新的 Rust 稳定版本
- 🌐 **Actix Web 4.3.1** - 高性能的 Rust Web 框架
- 🐳 **Docker 支持** - 多阶段构建，优化镜像大小
- 🔧 **环境变量配置** - 端口可通过环境变量配置
- 📦 **清华源镜像** - 使用清华大学镜像源加速依赖下载
- 🚀 **一键部署** - 支持 Makefile 和 .eazy 配置

## 快速开始

### 环境要求

- Rust 1.89.0 或更高版本
- Cargo（Rust 包管理器）
- Docker（可选，用于容器化部署）

### 本地开发

1. **克隆项目**
```bash
git clone <项目地址>
cd rust1.89.0-template
```

2. **安装依赖**
```bash
make install
```

3. **启动应用**
```bash
make run
```

4. **访问应用**
   打开浏览器访问：http://localhost:8000

5. **停止应用**
```bash
make stop
```

### 环境变量配置

| 变量名 | 默认值 | 说明 |
|--------|--------|------|
| `APP_PORT_1` | 8000 | 应用监听端口 |

### Makefile 命令

本模板提供了三个核心 Makefile 命令：

- `make install`: 设置 Rust 工具链，检查版本，编译项目
- `make run`: 启动 Rust 应用（后台运行）
- `make stop`: 停止 Rust 应用

### Docker 部署

1. **构建镜像**
```bash
docker build -t rust-hello-world .
```

2. **运行容器**
```bash
docker run -p 8000:8000 -e APP_PORT_1=8000 rust-hello-world
```

## 项目结构

```
rust1.89.0-template/
├── .eazy                    # 应用配置文件
├── .resource/
│   └── resource_dev.json   # 资源配置文件
├── .vscode/                # VS Code 配置
├── src/
│   └── main.rs            # 主程序
├── Cargo.toml             # 依赖配置
├── Dockerfile             # Docker 构建文件
├── docker-entrypoint.sh   # Docker 启动脚本
├── Makefile              # 构建和运行脚本
├── .gitignore            # Git 忽略文件
└── README.md             # 项目说明文档
```

## 开发指南

### 添加新路由

在 `src/main.rs` 中添加新的处理函数和路由：

```rust
async fn new_handler() -> impl Responder {
    HttpResponse::Ok().body("New endpoint!")
}

// 在 main 函数中添加路由
.route("/new", web::get().to(new_handler))
```

### 添加依赖

在 `Cargo.toml` 的 `[dependencies]` 部分添加新的依赖：

```toml
[dependencies]
actix-web = "4.3.1"
serde = "1.0"  # 新增依赖
```

### 配置说明

- **Cargo.toml**: 配置了清华源镜像，加速依赖下载
- **Dockerfile**: 使用多阶段构建，最终镜像基于 Debian Bookworm
- **Makefile**: 提供 install、run、stop 命令
- **.eazy**: 应用部署配置文件

## API 接口

### GET /

返回简单的 Hello World 消息。

**响应示例：**
```
Hello, World!
```

## 部署说明

### 使用 .eazy 配置部署

项目包含 `.eazy` 配置文件，支持一键部署：

- **端口映射**: APP_PORT_1 (8000) 作为主端口
- **资源限制**: CPU 0.5核，内存 2GB，存储 1GB
- **访问入口**: 支持外网域名访问

### 生产环境建议

1. **性能优化**: 根据实际负载调整资源限制
2. **安全配置**: 配置 HTTPS 和防火墙规则
3. **监控日志**: 集成日志收集和监控系统
4. **健康检查**: 添加健康检查端点

## 故障排除

### 常见问题

1. **端口被占用**
```bash
# 查看端口占用
lsof -i :8000
# 或使用 make stop 停止应用
```

2. **依赖下载失败**
   - 检查网络连接
   - 确认 Cargo.toml 中的清华源配置

3. **Docker 构建失败**
   - 检查 Dockerfile 语法
   - 确认基础镜像可用

## 贡献指南

1. Fork 项目
2. 创建特性分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 打开 Pull Request

## 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 联系方式

如有问题或建议，请通过以下方式联系：

- 项目 Issues: [GitLab Issues](项目地址/-/issues)
- 邮箱: [联系邮箱]

---

**Happy Coding with Rust! 🦀**
