use actix_web::{web, App, HttpResponse, HttpServer, Responder};
use std::env;

async fn hello() -> impl Responder {
    HttpResponse::Ok().body("Hello, World!")
}

#[actix_web::main]
async fn main() -> std::io::Result<()> {
    // 从环境变量获取端口，默认为 8080
    let port = env::var("APP_PORT_1").unwrap_or_else(|_| "8080".to_string());
    let bind_address = format!("0.0.0.0:{}", port);
    
    println!("Server running at http://{}", bind_address);

    HttpServer::new(|| {
        App::new()
            .route("/", web::get().to(hello))
    })
    .bind(&bind_address)?
    .run()
    .await
}
