const express = require('express');
const path = require('path');
const axios = require('axios');

const app = express();
const PORT = process.env.APP_PORT_2 || 8001;
const BACKEND_PORT = process.env.APP_PORT_1 || 8000;
const BACKEND_URL = process.env.API_URL || 'http://localhost:'+BACKEND_PORT;

// 中间件
app.use(express.json());
app.use(express.static(path.join(__dirname, 'public')));

// 代理API请求到Python后端
app.get('/api/hello', async (req, res) => {
    try {
        const response = await axios.get(`${BACKEND_URL}/api/hello`);
        res.json(response.data);
    } catch (error) {
        res.status(500).json({
            message: '无法连接到后端服务',
            error: error.message
        });
    }
});

app.post('/api/info', async (req, res) => {
    try {
        const response = await axios.post(`${BACKEND_URL}/api/info`, req.body);
        res.json(response.data);
    } catch (error) {
        res.status(500).json({
            message: '无法连接到后端服务',
            error: error.message
        });
    }
});

// 提供前端页面
app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, 'public', 'index.html'));
});

app.listen(PORT, () => {
    console.log(`前端服务器运行在端口 ${PORT}`);
    console.log(`后端API地址: ${BACKEND_URL}`);
});
