from flask import Flask, jsonify, request
from flask_cors import CORS
import os

app = Flask(__name__)
CORS(app)  # 允许跨域请求

@app.route('/', methods=['GET'])
def root():
    """根路径返回 helloworld"""
    return "helloworld"

@app.route('/api/hello', methods=['GET'])
def hello():
    """简单的Hello World API"""
    return jsonify({
        'message': 'Hello from Python backend!',
        'status': 'success',
        'data': {
            'backend': 'Python Flask',
            'frontend': 'Node.js',
            'timestamp': '2024-01-01T00:00:00Z'
        }
    })

@app.route('/api/info', methods=['POST'])
def get_info():
    """接收前端数据并返回信息的API"""
    try:
        data = request.get_json()
        name = data.get('name', 'Anonymous')
        message = data.get('message', 'No message')
        
        return jsonify({
            'message': f'Hello {name}!',
            'received_message': message,
            'status': 'success',
            'backend_response': 'Data received successfully from Python backend'
        })
    except Exception as e:
        return jsonify({
            'message': 'Error processing request',
            'status': 'error',
            'error': str(e)
        }), 400

if __name__ == '__main__':
    port = int(os.environ.get('APP_PORT_1', 8000))
    app.run(host='0.0.0.0', port=port, debug=True)
