<?php
/**
 * PHP Hello World Web Application
 * 从环境变量获取端口配置
 */

// 从环境变量获取端口，默认为 8000
$port = $_ENV['APP_PORT_1'] ?? '8000';

// 设置响应头
header('Content-Type: application/json; charset=utf-8');

// 返回 JSON 响应
$response = [
    'message' => 'Hello, World!',
    'port' => $port,
    'timestamp' => date('Y-m-d H:i:s'),
    'php_version' => PHP_VERSION,
    'server' => 'PHP Built-in Server'
];

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>