#!/bin/bash

# Node.js 20 HTTP 服务器容器启动脚本

set -e

echo "=== Node.js 20 HTTP 服务器容器启动 ==="
echo "Node.js版本: $(node --version)"
echo "工作目录: $(pwd)"
echo "端口: ${APP_PORT_1:-8080}"
echo ""

# 检查Node.js是否可用
if ! command -v node &> /dev/null; then
    echo "错误: Node.js未安装或不在PATH中"
    exit 1
fi

# 检查主文件是否存在
if [ ! -f "hello_world.js" ]; then
    echo "错误: hello_world.js文件不存在"
    exit 1
fi

# 安装依赖（如果有package.json）
if [ -f "package.json" ]; then
    echo "安装npm依赖..."
    npm install
fi

# 运行HTTP服务器
echo "启动HTTP服务器..."
echo "服务器将在端口 ${APP_PORT_1:-8080} 上运行"
echo "=========================================="
exec node hello_world.js
