# Node.js 20 HTTP 服务器项目

这是一个使用Node.js 20编写的简单HTTP服务器示例，展示了基本的Node.js网络编程和HTTP服务实现。

## 项目结构

```
node20-template/
├── hello_world.js              # 主程序文件
├── package.json                # Node.js项目配置
├── Dockerfile                  # Docker容器化配置
├── docker-entrypoint.sh        # Docker启动脚本
├── Makefile                    # 编译和运行脚本
└── README.md                   # 项目说明文档
```

## 功能特性

- ✅ 基于Node.js 20的HTTP服务器
- ✅ 使用内置的http模块
- ✅ 支持环境变量配置端口
- ✅ 返回"Hello World!"响应
- ✅ Makefile自动化运行和管理
- ✅ 支持后台运行和进程管理
- ✅ Docker容器化支持

## 环境要求

- Node.js 20 或更高版本
- npm（Node.js包管理器）
- Make工具（可选，用于自动化构建）
- Docker（可选，用于容器化运行）

## 快速开始

### 方法一：直接运行

```bash
# 直接运行HTTP服务器
node hello_world.js

# 或者使用npm
npm start
```

### 方法二：使用Makefile

```bash
# 安装依赖并准备项目
make install

# 启动HTTP服务器（后台运行）
make run

# 停止服务器
make stop
```

### 方法三：使用Docker

```bash
# 构建Docker镜像
docker build -t node20-hello-world .

# 运行容器
docker run -p 8080:8080 node20-hello-world

# 运行容器并指定端口
docker run -p 9090:8080 -e APP_PORT_1=8080 node20-hello-world
```

## 服务器使用示例

### 启动服务器
```bash
make run
# 输出：
# ✅ Node.js HTTP 服务器已启动，PID: 12345
# 服务器运行在: http://localhost:8080/
```

### 访问服务器
```bash
curl http://localhost:8080/
# 输出：Hello World!
```

```bash
make stop
# 输出：
# ✅ 所有相关Node.js进程已被强制停止
# ✅ 停止操作完成
```

## 代码说明

### hello_world.js

HTTP服务器类包含以下功能：

- **http模块**: 使用Node.js内置的http模块创建HTTP服务器
- **端口配置**: 监听8080端口
- **请求处理**: 处理所有HTTP请求并返回"Hello World!"响应
- **服务器启动**: 启动HTTP服务器并输出运行信息

### package.json

Node.js项目配置文件：

- **项目信息**: 定义项目名称、版本、描述等
- **脚本命令**: 定义start、dev等npm脚本
- **引擎要求**: 指定Node.js版本要求（>=18.0.0）

### Makefile

提供了以下核心命令：

- `install`: 检查Node.js版本并安装依赖
- `run`: 启动HTTP服务器（后台运行）
- `stop`: 停止HTTP服务器（强制停止所有相关进程）

### Dockerfile

- 基于EazyTec Node.js 20 Ubuntu镜像
- 自动安装依赖和运行HTTP服务器
- 支持端口配置（APP_PORT_1环境变量）
- 暴露8080端口

## 环境变量

- `APP_PORT_1`: HTTP服务器端口号（默认: 8080）

## 扩展建议

1. **添加更多路由**: 可以添加不同的URL路径处理
2. **静态文件服务**: 添加静态文件（HTML、CSS、JS）服务功能
3. **API接口**: 添加RESTful API接口
4. **日志记录**: 使用winston或pino进行日志记录
5. **配置文件**: 添加JSON或YAML配置文件支持
6. **Express框架**: 使用Express.js框架简化开发
7. **健康检查**: 添加健康检查端点
8. **HTTPS支持**: 添加SSL/TLS支持
9. **中间件**: 添加请求日志、错误处理等中间件
10. **数据库集成**: 添加数据库连接和操作

## 许可证

此项目仅用于学习和演示目的。
