/**
 * Node.js 16 HTTP 服务器
 * 一个简单的HTTP服务器，返回"Hello World!"响应
 */

var http = require('http');

// 从环境变量获取端口号，默认为8080
var port = process.env.APP_PORT_1 || 8080;

/**
 * 创建HTTP服务器
 * @param {Object} req - HTTP请求对象
 * @param {Object} res - HTTP响应对象
 */
http.createServer(function (req, res) {
  res.writeHead(200, {'Content-Type': 'text/html'});
  res.end('Hello World!');
}).listen(port, () => {
  console.log('Server running at http://0.0.0.0:' + port + '/');
});
