/**
 * KaboomJS游戏主文件
 * 这是一个简单的平台跳跃游戏示例
 */

/**
 * 初始化kaboom游戏引擎
 */
const k = kaboom({
    width: 800,
    height: 600,
    background: [135, 206, 235], // 天空蓝色背景
    debug: true, // 开启调试模式
});

/**
 * 加载游戏资源
 */
k.loadSprite("player", "https://kaboomjs.com/sprites/bean.png");
k.loadSprite("enemy", "https://kaboomjs.com/sprites/ghosty.png");
k.loadSprite("coin", "https://kaboomjs.com/sprites/coin.png");
k.loadSprite("grass", "https://kaboomjs.com/sprites/grass.png");
k.loadSprite("steel", "https://kaboomjs.com/sprites/steel.png");


/**
 * 主菜单场景
 */
k.scene("menu", () => {
    // 添加标题
    k.add([
        k.text("🎮 KaboomJS 游戏", { size: 48 }),
        k.pos(k.width() / 2, k.height() / 2 - 100),
        k.anchor("center"),
        k.color(255, 255, 255),
    ]);
    
    // 添加开始提示
    k.add([
        k.text("按空格键开始游戏", { size: 24 }),
        k.pos(k.width() / 2, k.height() / 2),
        k.anchor("center"),
        k.color(200, 200, 200),
    ]);
    
    // 添加控制说明
    k.add([
        k.text("控制说明：空格键跳跃，左右箭头移动", { size: 16 }),
        k.pos(k.width() / 2, k.height() / 2 + 100),
        k.anchor("center"),
        k.color(180, 180, 180),
    ]);
    
    // 监听空格键开始游戏
    k.onKeyPress("space", () => {
        k.go("game");
    });
});

/**
 * 游戏主场景
 */
k.scene("game", () => {
    // 设置重力
    k.setGravity(1600);
    
    // 创建地面平台
    for (let i = 0; i < k.width() / 64; i++) {
        k.add([
            k.sprite("grass"),
            k.pos(i * 64, k.height() - 64),
            k.area(),
            k.body({ isStatic: true }),
            k.scale(2),
            "ground"
        ]);
    }
    
    // 创建一些额外的平台（降低高度）
    k.add([
        k.sprite("steel"),
        k.pos(300, k.height() - 150),
        k.area(),
        k.body({ isStatic: true }),
        k.scale(2),
        "platform"
    ]);
    
    k.add([
        k.sprite("steel"),
        k.pos(500, k.height() - 200),
        k.area(),
        k.body({ isStatic: true }),
        k.scale(2),
        "platform"
    ]);
    
    // 添加更多较低的平台
    k.add([
        k.sprite("steel"),
        k.pos(650, k.height() - 120),
        k.area(),
        k.body({ isStatic: true }),
        k.scale(1.5),
        "platform"
    ]);
    
    // 创建玩家
    const player = k.add([
        k.sprite("player"),
        k.pos(100, k.height() - 150),
        k.area(),
        k.body(),
        k.scale(2),
        "player"
    ]);
    
    // 创建敌人
    const enemy = k.add([
        k.sprite("enemy"),
        k.pos(400, k.height() - 150),
        k.area(),
        k.body(),
        k.scale(1.5),
        "enemy"
    ]);
    
    // 创建金币
    const coin = k.add([
        k.sprite("coin"),
        k.pos(350, k.height() - 180), // 放在较低平台上
        k.area(),
        k.scale(1.5),
        "coin"
    ]);
    
    // 添加更多金币
    k.add([
        k.sprite("coin"),
        k.pos(550, k.height() - 230),
        k.area(),
        k.scale(1.5),
        "coin"
    ]);
    
    k.add([
        k.sprite("coin"),
        k.pos(700, k.height() - 150),
        k.area(),
        k.scale(1.5),
        "coin"
    ]);
    
    // 分数
    let score = 0;
    const scoreLabel = k.add([
        k.text("分数: 0", { size: 24 }),
        k.pos(20, 20),
        k.color(255, 255, 255),
    ]);
    
    // 玩家控制
    k.onKeyPress("space", () => {
        if (player.isGrounded()) {
            player.jump(800); // 增加跳跃力
        }
    });
    
    k.onKeyDown("left", () => {
        player.move(-200, 0);
    });
    
    k.onKeyDown("right", () => {
        player.move(200, 0);
    });
    
    // 碰撞检测 - 玩家与金币
    player.onCollide("coin", (coin) => {
        k.destroy(coin);
        score += 10;
        scoreLabel.text = `分数: ${score}`;
        
        // 创建新金币（在更合理的高度）
        k.add([
            k.sprite("coin"),
            k.pos(k.rand(100, k.width() - 100), k.rand(k.height() - 250, k.height() - 120)),
            k.area(),
            k.scale(1.5),
            "coin"
        ]);
    });
    
    // 碰撞检测 - 玩家与敌人
    player.onCollide("enemy", () => {
        k.go("gameover", score);
    });
    
    // 防止玩家掉出屏幕
    player.onUpdate(() => {
        if (player.pos.y > k.height()) {
            k.go("gameover", score);
        }
        
        // 限制玩家在屏幕内
        if (player.pos.x < 0) {
            player.pos.x = 0;
        }
        if (player.pos.x > k.width() - 32) {
            player.pos.x = k.width() - 32;
        }
    });
    
    // 敌人简单AI
    let enemyDirection = 1;
    enemy.onUpdate(() => {
        // 在地面上左右移动
        enemy.move(enemyDirection * 80, 0);
        
        // 到达边界时转向
        if (enemy.pos.x <= 200 || enemy.pos.x >= 600) {
            enemyDirection *= -1;
        }
    });
    
    // 游戏说明
    k.add([
        k.text("空格键跳跃，左右箭头移动，收集金币，避开幽灵！", { size: 16 }),
        k.pos(k.width() / 2, k.height() - 30),
        k.anchor("center"),
        k.color(255, 255, 255),
    ]);
});

/**
 * 游戏结束场景
 */
k.scene("gameover", (score) => {
    k.add([
        k.text("游戏结束!", { size: 48 }),
        k.pos(k.width() / 2, k.height() / 2 - 100),
        k.anchor("center"),
        k.color(255, 0, 0),
    ]);
    
    k.add([
        k.text(`最终得分: ${score}`, { size: 24 }),
        k.pos(k.width() / 2, k.height() / 2 - 50),
        k.anchor("center"),
        k.color(255, 255, 255),
    ]);
    
    k.add([
        k.text("按空格键重新开始", { size: 18 }),
        k.pos(k.width() / 2, k.height() / 2 + 50),
        k.anchor("center"),
        k.color(200, 200, 200),
    ]);
    
    k.add([
        k.text("按M键返回主菜单", { size: 18 }),
        k.pos(k.width() / 2, k.height() / 2 + 80),
        k.anchor("center"),
        k.color(200, 200, 200),
    ]);
    
    k.onKeyPress("space", () => {
        k.go("game");
    });
    
    k.onKeyPress("m", () => {
        k.go("menu");
    });
});

/**
 * 启动游戏
 */
console.log("KaboomJS 游戏正在启动...");
k.go("menu");