# 🎮 KaboomJS 游戏模板

这是一个基于 [KaboomJS](https://kaboomjs.com/) 的游戏开发模板，提供了一个完整的游戏开发环境和示例游戏。

## 📋 项目概述

KaboomJS 是一个轻量级的 JavaScript 游戏引擎，专为快速原型开发和简单游戏制作而设计。本模板包含：

- 🎯 完整的平台跳跃游戏示例
- 🚀 开发和生产环境配置
- 🐳 Docker 容器化支持
- 📦 自动化构建和部署脚本
- 🎨 现代化的用户界面设计

## 🚀 快速开始

### 本地开发

1. **克隆项目**
```bash
git clone <repository-url>
cd kaboomjs-template
```

2. **安装依赖**
```bash
make install
# 或者
npm install
```

3. **启动开发服务器**
```bash
make dev
# 或者
npm run dev
```

4. **打开浏览器访问**
```
http://localhost:3000
```

### Docker 部署

1. **构建并运行 Docker 容器**
```bash
make docker-run
```

2. **访问游戏**
```
http://localhost:3000
```

## 🎮 游戏说明

这是一个简单的平台跳跃游戏，包含以下特性：

### 游戏机制
- **角色控制**: 使用空格键跳跃，左右箭头键移动
- **收集系统**: 收集金币获得分数
- **敌人系统**: 避开敌人，否则游戏结束
- **场景切换**: 包含主菜单、游戏场景和游戏结束场景

### 游戏特性
- 🎯 物理引擎支持（重力、碰撞检测）
- 🎵 音效系统
- 🎨 精美的像素艺术风格
- 📱 响应式设计，支持不同屏幕尺寸
- 🏆 分数系统

## 📁 项目结构

```
kaboomjs-template/
├── package.json          # 项目配置和依赖
├── index.html            # 游戏入口页面
├── game.js               # 主游戏逻辑
├── lib/
│   └── kaboom.js         # KaboomJS 本地库文件
├── .eazy                 # 项目配置文件
├── .resource/
│   └── resource_dev.json # 外部资源配置
├── Dockerfile            # Docker 配置
├── docker-entrypoint.sh  # Docker 启动脚本
├── Makefile              # 自动化构建脚本
└── README.md             # 项目说明文档
```

## 🛠️ 开发指南

### 核心文件说明

#### `game.js` - 游戏主逻辑
```javascript
/**
 * 游戏的核心逻辑，包含：
 * - 游戏引擎初始化
 * - 资源加载
 * - 场景定义
 * - 游戏机制实现
 */
```

#### `index.html` - 游戏入口
- 游戏的 HTML 入口文件
- 包含游戏界面样式
- 提供游戏说明和控制提示

### 自定义游戏

1. **修改游戏设置**
```javascript
const k = kaboom({
    width: 800,    // 游戏宽度
    height: 600,   // 游戏高度
    background: [135, 206, 235], // 背景色
    debug: true,   // 调试模式
});
```

2. **添加新的精灵和音效**
```javascript
k.loadSprite("newSprite", "path/to/sprite.png");
k.loadSound("newSound", "path/to/sound.wav");
```

3. **创建新的游戏对象**
```javascript
const newObject = k.add([
    k.sprite("newSprite"),
    k.pos(x, y),
    k.area(),
    k.body(),
    "newTag"
]);
```

## 🔧 Makefile 命令

本模板提供了三个核心 Makefile 命令：

- `make install`: 检查 Node.js 和 npm 版本，安装项目依赖
- `make run`: 启动 KaboomJS 游戏服务器（后台运行）
- `make stop`: 停止 KaboomJS 游戏服务器

### 其他可用命令
```bash
npm run dev       # 开发模式（前台运行，热重载）
npm start         # 直接启动游戏服务器
```

### 维护命令
```bash
make test         # 测试项目
make clean        # 清理项目文件
make clean-all    # 完全清理（包括Docker）
make info         # 显示项目信息
make help         # 显示帮助信息
```

## 📦 依赖说明

### 本地库文件
- **lib/kaboom.js**: KaboomJS 游戏引擎核心库（本地版本，无需网络连接）

### 开发依赖
- **http-server**: 开发和生产服务器

### 优势
- ✅ **离线运行**: 无需网络连接，完全本地化
- ✅ **加载速度快**: 本地文件加载，无CDN延迟
- ✅ **版本稳定**: 锁定特定版本，避免CDN更新导致的兼容性问题

## 🌐 部署选项

### 1. 静态文件部署
游戏可以作为静态文件部署到任何 Web 服务器：
```bash
# 复制文件到 Web 服务器目录
cp -r . /var/www/html/kaboomjs-game/
```

### 2. Docker 容器部署
```bash
# 构建镜像
docker build -t kaboomjs-game .

# 运行容器
docker run -d -p 3000:3000 kaboomjs-game
```

### 3. 云平台部署
- **Vercel**: 直接部署静态文件
- **Netlify**: 支持持续集成部署
- **GitHub Pages**: 免费静态网站托管

## 🎨 自定义主题

### 修改游戏外观
1. **背景颜色**
```javascript
background: [R, G, B] // RGB 颜色值
```

2. **游戏尺寸**
```javascript
width: 800,   // 宽度
height: 600,  // 高度
```

3. **UI 样式**
修改 `index.html` 中的 CSS 样式

## 🔍 调试和开发

### 开启调试模式
```javascript
const k = kaboom({
    debug: true, // 显示碰撞边界和调试信息
});
```

### 常用调试功能
- 显示 FPS
- 显示碰撞边界
- 控制台日志输出
- 性能监控

## 📚 学习资源

### KaboomJS 官方资源
- [官方网站](https://kaboomjs.com/)
- [官方文档](https://kaboomjs.com/doc)
- [示例游戏](https://kaboomjs.com/play)
- [API 参考](https://kaboomjs.com/doc/intro)

### 游戏开发教程
- [KaboomJS 入门教程](https://kaboomjs.com/doc/intro)
- [制作你的第一个游戏](https://kaboomjs.com/doc/intro)
- [高级游戏机制](https://kaboomjs.com/doc)

## 🤝 贡献指南

欢迎提交问题和改进建议！

1. Fork 项目
2. 创建功能分支
3. 提交更改
4. 推送到分支
5. 创建 Pull Request

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 🙏 致谢

- [KaboomJS](https://kaboomjs.com/) - 优秀的游戏引擎
- [Node.js](https://nodejs.org/) - JavaScript 运行时
- [Docker](https://www.docker.com/) - 容器化平台

## 📞 支持

如果您遇到任何问题或需要帮助，请：

1. 查看 [FAQ](#) 部分
2. 搜索现有的 [Issues](../../issues)
3. 创建新的 [Issue](../../issues/new)
4. 联系维护者

---

**快乐游戏开发！** 🎮✨
